let groups = 0
let generation = 1
const express = require('express')
const app = express()
const port = 3000
const shell = require('shelljs')
const cron = require('node-cron');
const cronRemover = require('node-cron');
const cronRemover2 = require('node-cron');
const request = require('request');
const fs = require('fs')
const cronSpeed = require('node-cron');
const shellExec = require('shell-exec')
let Hetzner = require('./Hetzner')
let constant = require('./constant')
let masterId = 0


let het
var decimalPointRegex = /\-?\d+\.\d+/g;
app.get('/', (req, res) => {
    res.send('Hello World!')
    run()
})
const cryptLib = require('@skavinvarnan/cryptlib');
const key = "6*sN_rZxHD4!X$=T";

app.get('/ip/:ip/', (req, res) => {
    // console.log(req.params.acc)
    return addNewIp(req, res)

})

app.get('/add/:num/', (req, res) => {
    // console.log(req.params.acc)
    return newFloatingIpsOrder(req, res)

})

app.get('/createServer/:num/', (req, res) => {
    // console.log(req.params.acc)
    return newServerOrder(req, res)

})

app.get('/del/', (req, res) => {
    // console.log(req.params.acc)
    res.send('Done')
    het.removeAllFloatingIps()

})

app.get('/test', (req, res) => {
    // console.log(req.params.acc)
    res.sendfile('jetmtp.png')

})


async function newServerOrder(req, res) {
    let order = parseInt(req.params.num)


    res.send('Create Server from ' + (order === 1 ? 'Nuremberg' : order === 2 ? 'Falkenstein' : 'Helsinki') + ' Requested')
    let ips = await het.getAllServers()
    if (ips.length === 10)
        return

    let floatNum = 10 - ips.length
    let location
    if (order === 1)
        location = constant.nuremberg
    else if (order === 2)
        location = constant.falkenstein
    else
        location = constant.helsinki

    let newIps = []

    for (let i = 1; i <= floatNum; i++) {

        let ip = await het.createServer(location, order === 3)
        addBaship(ip)

        newIps.push(ip)
    }

    // console.log(req.params.ip)
    // addBaship(req.params.ip)
}

async function addBaship(ip) {
    return shell.exec(' ip addr add ' + ip + ' dev eth0').stderr;

}

app.listen(port, () => console.log(`Example app listening on port ${port}!`))


async function run() {
    let a = await shell.exec('cd .. &&  cd mt  && sudo ./server1.sh', {silent: true}).stdout;
    // await shell.exec('iptables -A INPUT -s 95.156.255.148 -p ICMP --icmp-type 8 -j ACCEPT && iptables -A INPUT -p ICMP --icmp-type 8 -j DROP', {silent: true}).stdout;
    console.log('Reset Proxy')
}

async function checkProcessWork() {
    let a = await shell.exec('nc -vz 127.0.0.1 443').stderr;
    if (a.includes('succeeded'))
        return true
    run()
}

cron.schedule('*/10 * * * * *', () => {

    checkProcessWork()
});

postRequest()
cronRemover.schedule(' */1 * * * *', () => {
    init()

});

cronRemover2.schedule(' */15 * * * *', () => {
    checkServers()

});
init()

async function init() {
    await initToken()
    addMaster()
    postRequest()
    attacher()
    // checkServers()

}


async function checkServers() {
    let servers = await het.getAllServers()

    if (masterId ===0)
        return
    for (let i = 0; i < servers.length; i++)
        if (servers[i].id !== masterId) {

            let min = getMinDiff(servers[i].created)

            let status = await getWorkMaster(servers[i].publicNet.server.publicNet.ipv4.ip)
            status = parseInt(status)
            switch (status) {
                case 404:


                    if (min > 30) {
                        await het.deleteServer(servers[i].id)
                        console.log('Need remove server ' + servers[i].name + '  Idle is ' + min)
                    }

                    break
                case 400:
                    if (min > 20) {
                        await het.deleteServer(servers[i].id)
                        console.log('Need remove server ' + servers[i].name + '  Idle is ' + min)
                    }
                    break
                case 0:
                    console.log('Need remove server ' + servers[i].name + '  Status is 0')
                    await het.deleteServer(servers[i].id)
                    break
                case 1:
                    console.log('All work server ' + servers[i].name)
                    break
            }


            //  console.log(getMinDiff(servers[i].created))
        }
}

function getMinDiff(end) {
    //2019-05-25T05:34:27+04:30
    let moment = require('moment-timezone')
    var now = moment(moment().tz('Asia/Tehran').format());
    var end = moment.duration(now.diff(moment(end).tz('Asia/Tehran')));
    return parseInt(end.asMinutes())


}


async function checkIps(ip) {


    let status = await getWorkFloating(ip)
    status = parseInt(status)
    switch (status) {
        case 404:
            await postFloatingIps([ip])
            break
        case 400:
            await postFloatingIps([ip])
            break
        case 0:
            await het.removeFloatingIpByIp(ip)
            break
        case 1:
            break
    }


}

async function initToken() {
    var contents = await fs.readFileSync('./token.txt', 'utf8');
    het = new Hetzner(contents)
    masterId = await het.getMasterServerId()
    //  remover()


}


async function addNewIp(req, res) {
    res.send('Hello World!')
    console.log(req.params.ip)
    addBaship(req.params.ip)
}


async function newFloatingIpsOrder(req, res) {
    let order = parseInt(req.params.num)
    res.send('Floating Ips from ' + (order === 1 ? 'Nuremberg' : order === 2 ? 'Falkenstein' : 'Helsinki') + ' Requested')
    let ips = await het.getAllFloatingIps()
    if (ips.length === 10)
        return

    let floatNum = 10 - ips.length
    let location = order === 1 ? constant.nuremberg : order === 2 ? constant.falkenstein : constant.helsinki


    for (let i = 1; i <= floatNum; i++) {

        let ip = await het.createFloatingIp(location)


    }


}

async function attacher() {
    let serverId = await het.getMasterServerId()
    serverId = parseInt(serverId)
    let ips = await het.getAllFloatingIps()
    let attached = false
    for (let i = 0; i < ips.length; i++) {
        if (typeof ips[i].server === "number") {
            if (ips[i].server === serverId) {
                attached = true
                await postFloatingIps([ips[i].ip])
                addBaship(ips[i].ip)
                return checkIps(ips[i].ip)
            }
        }

    }


    for (let i = 0; i < ips.length; i++) {
        if (typeof ips[i].server !== "number") {
            await het.updateFlotingIP(ips[i].id, serverId)
            await postFloatingIps([ips[i].ip])
            addBaship(ips[i].ip)
            break
        }


    }

    return true

}

function postFloatingIps(data) {

    data = JSON.stringify(data)
    data = cryptLib.encryptPlainTextWithRandomIV(data, key)


    var options = {
        method: 'POST',
        url: 'http://admin.fcfglobal.co:3000/addFloatingIp',
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        body: 'data=' + Buffer.from(data).toString('base64')

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {
            if (error)
                console.log(error)
            resolve(true)

        });
    });
}

async function remover() {
    let work = await getWork()
    if (work === 'true')
        return true
    let ip = await getIp()
    await het.removeByIp(ip)

}


function getWork() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/work/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}


function getWorkFloating(ip) {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/getIpDetail/' + ip
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}

function getWorkMaster(ip) {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/getMasterIpDetail/' + ip
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}


function addIp() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/add/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });


}

function getIp() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/getIp/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}


function addMaster() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/addMaster/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}

function postRequest() {
    let data = {generation: generation, groups: groups}
    data = JSON.stringify(data)
    data = cryptLib.encryptPlainTextWithRandomIV(data, key)


    var options = {
        method: 'POST',
        url: 'http://admin.fcfglobal.co:3000/addIp',
        headers: {'content-type': 'application/x-www-form-urlencoded'},
        body: 'data=' + Buffer.from(data).toString('base64')

    };


    return new Promise(function (resolve, reject) {
        request(options, function (error, response, body) {
            if (error)
                console.log(error)
            resolve(true)

        });
    });
}

async function calculateSpeed() {


    let d = await shellExec('vnstat -tr')
    d = d.stdout

    let arr = d.match(decimalPointRegex)


    if (d.includes('kbit/s')) {
        arr[0] = 1
        arr[1] = 1
    } else if (d.includes('Mbit/s')) {

    } else if (d.includes('Gbit/s')) {
        arr[0] = arr[0] * 1000
        arr[1] = arr[1] * 1000
    } else if (d.includes('bit/s')) {
        arr[0] = 1
        arr[1] = 1
    }


    await sendRate(arr[0], arr[1])


}

function sendRate(rx, tx) {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/rate/' + rx + '/' + tx
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 6000}, function (error, res, body) {
            resolve(true)

        });
    });

}


cronSpeed.schedule(' */5 * * * * *', () => {

    calculateSpeed()

});
