const HetznerCloud = require('hcloud-js')
let client
let _ = require('lodash')
let tokens
const words = require('an-array-of-english-words')

let oldG = '#!/bin/bash\n' +
    'cd /root\n' +
    'git clone http://git.fcfglobal.co/root/mt2.git\n' +
    '    mv mt2 mt\n' +
    'cd mt\n' +
    'sudo chmod 777 *\n' +
    'sudo ./install.sh\n' +
    'cd ..\n' +
    '    git clone http://git.fcfglobal.co/root/newhet.git\n' +
    '    cd newhet\n' +
    'echo ahmad > token.txt\n' +
    'sudo chmod 777 *\n' +
    'sudo ./run.sh\n' +
    'sleep 20'

let newG = '#!/bin/bash\n' +
    'cd /root\n' +
    'apt-get update -y\n' +
    'apt install -y git\n' +
    'git clone http://git.fcfglobal.co/root/Hetzner-Mt2-NewGeneration.git\n' +
    '    mv Hetzner-Mt2-NewGeneration mt\n' +
    'cd mt\n' +
    'sudo chmod 777 *\n' +
    'sudo ./install.sh\n' +
    'cd ..\n' +
    '    git clone http://git.fcfglobal.co/root/Hetzner-NewGeneration.git\n' +
    '    mv Hetzner-NewGeneration newhet\n' +
    '    cd newhet\n' +
    'echo ahmad > token.txt\n' +
    'sudo chmod 777 *\n' +
    'sudo ./run.sh\n' +
    'sleep 20'


class Hetzner {


    constructor(token) {

        client = new HetznerCloud.Client(_.trim(token))
        tokens = _.trim(token)
    }


    getAllServers() {
        return new Promise(function (resolve, reject) {

            client.servers.list().then(function (res) {
                // console.log(res)
                let d = _.values(res.servers);
                resolve(d)

            })
        })


    }


    getAllFloatingIps() {
        return new Promise(function (resolve, reject) {

            client.floatingIPs.list().then(function (res) {

                let d = _.values(res.floatingIPs);

                resolve(d)

            })
        })


    }


    async deleteServer(id) {
        return new Promise(function (resolve, reject) {

            client.servers.delete(id).then(function (res) {
                resolve(res)
            })
        })
    }

    async delFloatingIp(id) {
        return new Promise(function (resolve, reject) {

            client.floatingIPs.delete(id).then(function (res) {
                resolve(res)
            })
        })
    }

    async removeByIp(ip) {
        try {
            ip = _.trim(ip)
            console.log('try to remove ip:' + ip)
            let servers = await this.getAllServers()
            for (let i = 0; i < servers.length; i++) {
                if (ip === servers[i].publicNet.server.publicNet.ipv4.ip) {

                    await this.deleteServer(servers[i].id)
                }


            }
        } catch (e) {

        }
        return true

    }


    async removeFloatingIpByIp(ip) {
        try {
            ip = _.trim(ip)
            console.log('try to remove ip:' + ip)
            let ips = await this.getAllFloatingIps()
            for (let i = 0; i < ips.length; i++) {
                if (ip === ips[i].ip) {

                    await this.delFloatingIp(ips[i].id)
                }


            }
        } catch (e) {

        }
        return true

    }


    async removeAllFloatingIps() {
        try {


            let ips = await this.getAllFloatingIps()
            for (let i = 0; i < ips.length; i++) {


                await this.delFloatingIp(ips[i].id)


            }
        } catch (e) {

        }
        return true

    }


    async getIp() {
        const request = require('request');
        let url = 'http://admin.fcfglobal.co:3000/getIp/'
        return new Promise(function (resolve, reject) {
            request(url, {timeout: 15000}, function (error, res, body) {
                resolve(body)

            });
        });

    }

    async getMasterServerId() {
        try {

            let ip = await this.getIp()
            let servers = await this.getAllServers()


            for (let i = 0; i < servers.length; i++) {
                if (servers[i].publicNet.server.publicNet.ipv4.ip === ip) {

                    return servers[i].id
                }


            }
        } catch (e) {

        }
        return true

    }


    createServer(region, newGeneration) {



        let rand = randomInt(0, words.length)
        return new Promise(function (resolve, reject) {

            let command = newG

            command = command.replace('ahmad', tokens)

            client.servers.build(rand)
                .serverType('cx51')
                .location(region)
                .userData(command)
                .image('ubuntu-18.04')
                .create()
                .then(function (response) {
                    resolve(response)
                })
                .catch(function (error) {
                    console.log(error)
                    reject(error)
                    // Handle error...
                })
        })

    }

    randomInt(low, high) {
        return Math.floor(Math.random() * (high - low) + low)
    }

    createFloatingIp(location, server) {

        // nuremberg nbg1
        //fsn1

        return new Promise(function (resolve, reject) {
            client.floatingIPs.build()
                .type('ipv4')
                .location(location)
                .create()
                .then(function (response) {


                    resolve(response)

                })
                .catch(function (error) {
                    resolve(false)
                })
        })

    }


    updateFlotingIP(id, serverId) {

        // nuremberg nbg1
        //fsn1

        return new Promise(function (resolve, reject) {

            client.floatingIPs.actions.assign(id,serverId)
                .then(function (response) {
                    let d = _.values(response.floatingIP);

                    resolve(d)

                })
                .catch(function (error) {
                    resolve(false)
                })
        })

    }


}


module.exports = Hetzner;
