const express = require('express')
const app = express()
const port = 3000
const shell = require('shelljs')
const cron = require('node-cron');
const cronOne = require('node-cron');

const cronSpeed = require('node-cron');
const shellExec = require('shell-exec')
var decimalPointRegex = /\-?\d+\.\d+/g;


let countReboot = 5
let tryFail = 0

app.get('/', (req, res) => {
    res.send('Hello World!')
    run()
})

app.get('/ip/:ip/', (req, res) => {
    // console.log(req.params.acc)
    return addNewIp(req, res)

})

app.get('/rst2', (req, res) => {

    return reboot()

})

app.get('/test', (req, res) => {
    // console.log(req.params.acc)
    res.sendfile('jetmtp.png')

})

async function addNewIp(req, res) {
    res.send('Hello World!')
    console.log(req.params.ip)
    addBaship(req.params.ip)
}

async function addBaship(ip) {
    return await shell.exec(' ip addr add ' + ip + ' dev eth0').stderr;

}


async function reboot() {
    return await shell.exec(' sudo reboot ').stderr;

}

app.listen(port, () => console.log(`Example app listening on port ${port}!`))


async function run() {
    let a = await shell.exec('cd .. &&  cd mt  && sudo ./server1.sh', {silent: true}).stdout;
    console.log('Reset Proxy')
}

async function checkProcessWork() {
    let a = await shell.exec('nc -vz 127.0.0.1 443').stderr;
    if (a.includes('succeeded')) {
        tryFail = 0
        return true

    }
    tryFail++
    if (tryFail >= countReboot)
    {
        reboot()
        return
    }

    run()
}

cron.schedule('*/10 * * * * *', () => {

    checkProcessWork()
});


async function calculateSpeed() {


    let d = await shellExec('vnstat -tr')
    d = d.stdout

    let arr = d.match(decimalPointRegex)


    if (d.includes('kbit/s')) {
        arr[0] = 1
        arr[1] = 1
    } else if (d.includes('Mbit/s')) {

    } else if (d.includes('Gbit/s')) {
        arr[0] = arr[0] * 1000
        arr[1] = arr[1] * 1000
    } else if (d.includes('bit/s')) {
        arr[0] = 1
        arr[1] = 1
    }


    await sendRate(arr[0], arr[1])


}


function sendRate(rx, tx) {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/rate/' + rx + '/' + tx
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 6000}, function (error, res, body) {
            resolve(true)

        });
    });

}


cronSpeed.schedule(' */5 * * * * *', () => {

    return calculateSpeed()

});

