require('dotenv').config();
require('./utils/os').initOs();
const db = require('./db')
const message = require('./message')
const constant = require('./const')
const cron = require('node-cron');
let mysqldump = require('mysqldump')
let moment = require('moment-timezone')

const TelegramBot = require('node-telegram-bot-api');
const token = process.env.DEBUG === 'true' ? process.env.LOCAL_TOKEN : process.env.SERVER_TOKEN;


cron.schedule('*/10 * * * *', () => {

    runCron()

});


const bot = new TelegramBot(token, {polling: true});


bot.on('message', (msg) => {
    console.log(msg)
    processMessage(msg)

});


async function processMessage(msg) {

    await isAdmin(msg)
    if (msg.document) {
        commitDoc(msg)
        return
    }

    if (msg.text)
        msg.text = fa2en(msg.text)
    if (msg.text.includes("start"))
        message.startMessage(bot, msg)
    else if (msg.text.includes("لیست اعضا"))
        listuser(msg)
    else
        elseMessage(msg)
}

bot.on('callback_query', function onCallbackQuery(msg) {
    processCallback(msg)
});

async function processCallback(msg) {

    await isAdmin(msg)
    if (msg.data.startsWith("user_")) showUser(msg)
    else if (msg.data.startsWith("request_")) request(msg)
    else if (msg.data.startsWith("buy_")) showCurrency(msg, 'buy')
    else if (msg.data.startsWith("sell_")) showCurrency(msg, 'sell')
    else if (msg.data.startsWith("variz_")) showCurrency(msg, 'variz')
    else if (msg.data.startsWith("daryaft_")) showCurrency(msg, 'daryaft')
    else if (msg.data.startsWith("toman_")) showCount(msg, 'toman')
    else if (msg.data.startsWith("dollar_")) showCount(msg, 'dollar')
    else if (msg.data.startsWith("euro_")) showCount(msg, 'euro')
    else if (msg.data.startsWith("lir_")) showCount(msg, 'lir')
    else if (msg.data.startsWith("aed_")) showCount(msg, 'aed')
    else if (msg.data.startsWith("can_")) showCount(msg, 'can')
    else if (msg.data.startsWith("pon_")) showCount(msg, 'pon')
    else if (msg.data.startsWith("aud_")) showCount(msg, 'aud')
    else if (msg.data.startsWith("rmb_")) showCount(msg, 'rmb')
    else if (msg.data.startsWith("Rtoman_")) commitRequest(msg, 'toman')
    else if (msg.data.startsWith("Rdollar_")) commitRequest(msg, 'dollar')
    else if (msg.data.startsWith("Reuro_")) commitRequest(msg, 'euro')
    else if (msg.data.startsWith("Rlir_")) commitRequest(msg, 'lir')
    else if (msg.data.startsWith("Raed_")) commitRequest(msg, 'aed')
    else if (msg.data.startsWith("Rcan_")) commitRequest(msg, 'can')
    else if (msg.data.startsWith("Rpon_")) commitRequest(msg, 'pon')
    else if (msg.data.startsWith("Raud_")) commitRequest(msg, 'aud')
    else if (msg.data.startsWith("Rrmb_")) commitRequest(msg, 'rmb')
    else if (msg.data.startsWith("yes_")) yesNoDoc(msg, 'yes')
    else if (msg.data.startsWith("no_")) yesNoDoc(msg, 'no')


    else if (msg.data.startsWith("reportD")) reportRequest(msg, 1)
    else if (msg.data.startsWith("reportW")) reportRequest(msg, 7)
    else if (msg.data.startsWith("reportM")) reportRequest(msg, 30)
    else if (msg.data.startsWith("reqs_")) showRequest(msg)
}


async function listuser(msg) {

    let users = await db.getAllUsers()
    message.listUserMessage(bot, msg, users)

}

async function showUser(msg) {

    msg.data = msg.data.replace("user_", "")
    let user = await db.findUser(msg.data)

    message.userShowMessage(bot, msg, user)

}

async function request(msg) {

    msg.data = msg.data.replace("request_", "")
    let user = await db.findUser(msg.data)

    message.userSubmitRequest(bot, msg, user)

}

async function showCurrency(msg, type) {
    switch (type) {
        case 'buy':
            msg.data = msg.data.replace("buy_", "")
            break
        case 'sell':
            msg.data = msg.data.replace("sell_", "")
            break
        case 'variz':
            msg.data = msg.data.replace("variz_", "")
            break
        case 'daryaft':
            msg.data = msg.data.replace("daryaft_", "")
            break

    }

    let user = await db.findUser(msg.data)
    let data = {action: type, user: user.id}
    await db.updateData(msg, JSON.stringify(data))

    message.showCurrencyMessage(bot, msg, user)
}

async function showCount(msg, unit) {
    switch (unit) {
        case 'toman':
            msg.data = msg.data.replace("toman_", "")
            break
        case 'dolar':
            msg.data = msg.data.replace("dollar_", "")
            break
        case 'euro':
            msg.data = msg.data.replace("euro_", "")
            break
        case 'lir':
            msg.data = msg.data.replace("lir_", "")
            break
        case 'aed':
            msg.data = msg.data.replace("aed_", "")
            break
        case 'can':
            msg.data = msg.data.replace("can_", "")
            break
        case 'pon':
            msg.data = msg.data.replace("pon_", "")
            break
        case 'aud':
            msg.data = msg.data.replace("aud_", "")
            break
        case 'rmb':
            msg.data = msg.data.replace("rmb_", "")
            break

    }


    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    let type = admin.data.action
    // console.log(admin.data)
    admin.data.vahed = unit
    await db.updateData(msg, JSON.stringify(admin.data))

    message.showCountMessage(bot, msg, type === 'variz' || type === 'daryaft')
}

async function elseMessage(msg) {
    let admin = await db.findAdmin(msg)

    if (admin.status === constant.input1)
        input1(msg)
    else if (admin.status === constant.input2)
        input2(msg)


}

async function input1(msg) {
    let isvalid = numberValidation(msg)
    if (!isvalid) {
        message.simpleMessage(bot, msg, 'لطفا مقدار درست را وارد نمایید')
        return
    }

    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    let type = admin.data.action
    admin.data.count = msg.text

    admin.data = JSON.stringify(admin.data)

    await db.updateData(msg, admin.data)
    if (type === 'variz' || type === 'daryaft')
        message.sendDocMessage(bot, msg)
    else
        message.showFeeMessage(bot, msg)
}

async function input2(msg) {
    let isvalid = numberValidation(msg)
    if (!isvalid) {
        message.simpleMessage(bot, msg, 'لطفا مقدار درست را وارد نمایید')
        return
    }

    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    let data = admin.data
    admin.data.fee = msg.text
    await db.updateData(msg, JSON.stringify(admin.data))
    message.forwardCurrencyMessage(bot, msg, data)


}

async function yesNoDoc(msg, type) {

    if (type.includes('yes')) {
        message.deleteMessage(bot, msg)
        message.simpleMessage(bot, msg, 'لطفا فایل ضمیمه را ارسال کنید دقت شود که به عنوان فایل ارسال شود.')
        return
    }


    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    await db.createRequest(admin.data)

    await db.updateData(msg, null)
    message.deleteMessage(bot, msg)
    message.simpleMessage(bot, msg, 'فیش با موفقیت ثبت شد.')

}

async function commitRequest(msg, type) {


    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    admin.data.to = type
    let userId = admin.data.user
    // await db.createRequest(admin.data)

    await db.updateData(msg, JSON.stringify(admin.data))
    message.deleteMessage(bot, msg)
    message.sendDocMessage(bot, msg, userId)

}

async function commitDoc(msg) {
    let admin = await db.findAdmin(msg)
    admin.data = JSON.parse(admin.data)
    admin.data.file_id = msg.document.file_id
    await db.createRequest(admin.data)

    await db.updateData(msg, null)

    message.simpleMessage(bot, msg, 'فیش با موفقیت ثبت شد.')
}


function numberValidation(msg) {

    const st = fa2en(msg.text);
    const number = st;
    let phoneRGEX = RegExp('^[1-9]\\d*$');
    let phoneResult = phoneRGEX.test(number);
    return phoneResult !== false;
}

function fa2en(txt) {
    return txt.replace(/۱/g, "1").replace(/۲/g, "2").replace(/۳/g, "3").replace(/۴/g, "4").replace(/۵/g, "5").replace(/۶/g, "6").replace(/۷/g, "7").replace(/۸/g, "8").replace(/۹/g, "9")
        .replace(/۰/g, "0");

}

async function isAdmin(msg) {
    let admin = await db.findAdmin(msg)
    if (!admin) {
        message.simpleMessage(bot, msg, 'شما دسترسی  استفاده از ربات را ندارید.')
        throw 'Not Permission'
    }

    return true
}

async function canOrder(data, msg) {
    if (data.action === 'sell')
        return true

    let user = await db.findUser(data.user)

    let num = user.fee * user.count


    if (data.to === 'toman')
        if (user.toman_balance <= 0 || num > user.toman_balance) {
            generateText(user.toman_balance, num, msg)
        }

    if (data.to === 'dollar')
        if (user.dollar_balance <= 0 || num > user.dollar_balance) {
            generateText(user.dollar_balance, num, msg)
        }

    if (data.to === 'euro')
        if (user.euro_balance <= 0 || num > user.euro_balance) {
            generateText(user.euro_balance, num, msg)
        }

    if (data.to === 'lir')
        if (user.lir_balance <= 0 || num > user.lir_balance) {
            generateText(user.lir_balance, num, msg)
        }

    if (data.to === 'aed')
        if (user.aed_balance <= 0 || num > user.aed_balance) {
            generateText(user.aed_balance, num, msg)
        }

    if (data.to === 'can')
        if (user.can_balance <= 0 || num > user.can_balance) {
            generateText(user.can_balance, num, msg)
        }

    if (data.to === 'pon')
        if (user.pon_balance <= 0 || num > user.pon_balance) {
            generateText(user.pon_balance, num, msg)
        }

    if (data.to === 'aud')
        if (user.aud_balance <= 0 || num > user.aud_balance) {
            generateText(user.aud_balance, num, msg)
        }

    if (data.to === 'rmb')
        if (user.rmb_balance <= 0 || num > user.rmb_balance) {
            generateText(user.rmb_balance, num, msg)
        }


}

async function showRequest(msg) {
    msg.data = msg.data.replace("reqs_", "")
    let req = await db.findRequest(msg.data)
    message.deleteMessage(bot, msg)
    message.showRequest(bot, msg, req)

}


async function reportRequest(msg, date) {
    switch (date) {
        case 1:
            msg.data = msg.data.replace("reportD_", "")
            break
        case 7:
            msg.data = msg.data.replace("reportW_", "")
            break
        case 30:
            msg.data = msg.data.replace("reportM_", "")
            break
    }
    let reqs = await db.getRequestByDate(msg.data, date)
    //  console.log(reqs)
    message.deleteMessage(bot, msg)
    message.listRequest(bot, msg, reqs)
}

async function numeralgenerateText(current, num, msg) {
    let text = 'امکان فروش وجود ندارد موجودی فعلی : '
    text += current
    text += ' و مقدار درخواستی '
    text += num + ' '
    text += ' میباشد درصورتی که میخواهید عملیات انجام شود لطفا دسترسی لازم را بدهید'
    message.simpleMessage(bot, msg, text)
    throw 'Error canot do transaction'

}


async function runCron() {

    let name = './back/' + 'backup-' + moment().format('YYYY-MM-DD---HH-mm') + '.sql'
    const result = await mysqldump({
        connection: {
            host: '135.181.88.165',
            user: 'root',
            password: 'ramtin1383',
            database: 'accounting',
        }, dumpToFile: name,
    });
    bot.sendDocument('-1001152207818', name)
}





