const db = require('./db')
const constant = require('./const')
var numeral = require('numeral');
const nodeHtmlToImage = require('node-html-to-image')
function startMessage(bot, msg) {
    simpleMessage(bot, msg, 'به ربات حسابداری خودش آمدید.')
}

async function simpleMessage(bot, msg, text) {
    const opts = {
        reply_markup: {
            keyboard: [
                ['🇮🇷 لیست اعضا'],


            ],
            resize_keyboard: true,
            one_time_keyboard: true

        }
    };


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, text, opts)
}

async function listUserMessage(bot, msg, users) {
    const opts = {
        reply_markup: {
            inline_keyboard: []


        }
    };

    for (let i = 0; i < users.length; i++) {

        let text = users[i].first_name + " " + users[i].last_name

        opts.reply_markup.inline_keyboard.push([{
            text: text,
            callback_data: "user_" + users[i].id
        }])
    }
    await db.updateStatus(msg, constant.start)

    bot.sendMessage(msg.chat.id, 'لطفا کاربر مورد نظر را انتخاب کنید.', opts)
}



async function deleteMessage(bot, msg) {
    await bot.deleteMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, typeof msg.message_id !== 'undefined' ? msg.message_id : msg.message.message_id)
}


async function userShowMessage(bot, msg, user) {
    let table=tableGenerator('🇮🇷 ','تومان',numberize(Math.abs(user.toman_balance)),user.toman_balance === 0 ? '' :   user.toman_balance > 0 ? 'بدهکار' : 'بستانکار')

    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'ثبت فیش',
                        callback_data: 'request_' + user.id
                    }

                ]
                ,

                [

                    {
                        text: 'گزارش روزانه',
                        callback_data: 'reportD_' + user.id
                    }

                ]

                ,
                [

                    {
                        text: 'گزارش هفتگی',
                        callback_data: 'reportW_' + user.id
                    }

                ],
                [

                    {
                        text: 'گزارش ماهیانه',
                        callback_data: 'reportM_' + user.id
                    }

                ]
            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    let text = '🇮🇷 '
    text += numberize(Math.abs(user.toman_balance)) + ' ' + 'تومان' + ' '
    text += user.toman_balance === 0 ? '' :
        user.toman_balance > 0 ? 'بدهکار' : 'بستانکار'

    text += '\n'
    text += '\n'

    if (user.dollar_balance !== 0) {
        text += '🇺🇸 '
        text += numberize(Math.abs(user.dollar_balance)) + ' ' + 'دلار' + ' '
        text += user.dollar_balance === 0 ? '' :
            user.dollar_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'

     table+=   tableGenerator('🇺🇸 ','دلار',numberize(Math.abs(user.dollar_balance)),user.dollar_balance === 0 ? '' :   user.dollar_balance > 0 ? 'بدهکار' : 'بستانکار')

    }





    if (user.euro_balance !== 0) {
        text += '🇪🇺 '
        text += numberize(Math.abs(user.euro_balance)) + ' ' + 'یورو' + ' '
        text += user.euro_balance === 0 ? '' :
            user.euro_balance > 0 ? 'بدهکار' : 'بستانکار'
        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇪🇺 ','یورو',numberize(Math.abs(user.euro_balance)),user.euro_balance === 0 ? '' :   user.euro_balance > 0 ? 'بدهکار' : 'بستانکار')

    }

    if (user.lir_balance !== 0) {
        text += '🇹🇷 '
        text += numberize(Math.abs(user.lir_balance)) + ' ' + 'لیر' + ' '
        text += user.lir_balance === 0 ? '' :
            user.lir_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇹🇷 ','لیر',numberize(Math.abs(user.lir_balance)),user.lir_balance === 0 ? '' :   user.lir_balance > 0 ? 'بدهکار' : 'بستانکار')

    }

    if (user.aed_balance !== 0) {

        text += '🇦🇪 ' + numberize(Math.abs(user.aed_balance)) + ' ' + 'درهم' + " "
        text += user.aed_balance === 0 ? '' :
            user.aed_balance > 0 ? 'بدهکار' : 'بستانکار'
        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇦🇪 ','درهم',numberize(Math.abs(user.aed_balance)),user.aed_balance === 0 ? '' :   user.aed_balance > 0 ? 'بدهکار' : 'بستانکار')

    }

    if (user.can_balance !== 0) {
        text += '🇨🇦 '
        text += numberize(Math.abs(user.can_balance)) + ' ' + 'دلار کانادا' + ' '
        text += user.can_balance === 0 ? '' :
            user.can_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇨🇦 ','دلار کانادا',numberize(Math.abs(user.can_balance)),user.can_balance === 0 ? '' :   user.can_balance > 0 ? 'بدهکار' : 'بستانکار')


    }

    if (user.pon_balance !== 0) {
        text += '🇬🇧 '
        text += numberize(Math.abs(user.pon_balance)) + ' ' + 'پوند' + ' '
        text += user.pon_balance === 0 ? '' :
            user.pon_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇬🇧 ','پوند',numberize(Math.abs(user.pon_balance)),user.pon_balance === 0 ? '' :   user.pon_balance > 0 ? 'بدهکار' : 'بستانکار')

    }

    if (user.aud_balance !== 0) {
        text += '🇦🇺 '
        text += numberize(Math.abs(user.aud_balance)) + ' ' + 'دلار استرالیا' + ' '
        text += user.aud_balance === 0 ? '' :
            user.aud_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'


        table+=   tableGenerator('🇦🇺 ','دلار استرالیا',numberize(Math.abs(user.aud_balance)),user.aud_balance === 0 ? '' :   user.aud_balance > 0 ? 'بدهکار' : 'بستانکار')

    }

    if (user.rmb_balance !== 0) {
        text += '🇨🇳 '
        text += numberize(Math.abs(user.rmb_balance)) + ' ' + ' یوان چین' + ' '
        text += user.rmb_balance === 0 ? '' :
            user.rmb_balance > 0 ? 'بدهکار' : 'بستانکار'

        text += '\n'
        text += '\n'

        table+=   tableGenerator('🇨🇳 ','یوان چین',numberize(Math.abs(user.rmb_balance)),user.rmb_balance === 0 ? '' :   user.rmb_balance > 0 ? 'بدهکار' : 'بستانکار')

    }


    nodeHtmlToImage({
        output: './image.png',
        html: htmlGenerator(table),
        puppeteerArgs: { executablePath: '/usr/bin/chromium-browser',args: ['--no-sandbox']}
    })
        .then(() => bot.sendPhoto(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, './image.png'))

    bot.editMessageText(text, opts)
}

function tableGenerator(flag,curName,value,type)
{
let  q = ` <tr>
      <td>${flag}</td>
      <td>${curName}</td>
      <td>${value}</td>
      <td>${type}</td>
     
    </tr>
    
`

    return q
}

function htmlGenerator(table)
{
    let html='<!DOCTYPE html>\n<html>\n<head>\n<meta name="viewport" content="width=device-width, initial-scale=5">\n<style>\ntable {\n  border-collapse: collapse;\n  border-spacing: 0;\n  width: 100%;\n  border: 1px solid #ddd;\n}\n\nth, td {\n  text-align: right;\n  padding: 8px;\n}\n\ntr:nth-child(even){background-color: #f2f2f2}\n</style>\n</head>\n<body>\n\n\n<div style="overflow-x:auto;">\n  <table dir="rtl">\n    <tr >\n      <th>*</th>\n      <th>نام ارز</th>\n      <th>مانده حساب</th>\n      <th>وضعیت</th>\n      \n    </tr>\n    salam\n   \n  </table>\n</div>\n\n</body>\n</html>\n\n\n'
    html=html.replace('salam',table)
    return html
}

async function showCurrencyMessage(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'تومان',
                        callback_data: 'toman_' + user.id
                    }

                ],
                [

                    {
                        text: 'دلار',
                        callback_data: 'dollar_' + user.id
                    }

                ],
                [

                    {
                        text: 'یورو',
                        callback_data: 'euro_' + user.id
                    }

                ],
                [

                    {
                        text: 'لیر',
                        callback_data: 'lir_' + user.id
                    }

                ],
                [

                    {
                        text: 'درهم',
                        callback_data: 'aed_' + user.id
                    }

                ],
                [

                    {
                        text: 'دلار کانادا',
                        callback_data: 'can_' + user.id
                    }

                ],
                [

                    {
                        text: 'پوند',
                        callback_data: 'pon_' + user.id
                    }

                ],
                [

                    {
                        text: 'دلار استرالیا',
                        callback_data: 'aud_' + user.id
                    }

                ],
                [

                    {
                        text: 'یوان چین',
                        callback_data: 'rmb_' + user.id
                    }

                ]


            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.start)


    bot.editMessageText('لطفا نوع ارز را مشخص کنید.', opts)
}


async function userSubmitRequest(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'خرید',
                        callback_data: 'buy_' + user.id
                    }

                ]
                ,

                [

                    {
                        text: 'فروش',
                        callback_data: 'sell_' + user.id
                    }

                ],
                [

                    {
                        text: 'واریز',
                        callback_data: 'variz_' + user.id
                    }

                ],
                [

                    {
                        text: 'دریافت',
                        callback_data: 'daryaft_' + user.id
                    }

                ]


            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.start)


    bot.editMessageText('لطفا خرید یا فروش بودن معامله را مشخص کنید.', opts)
}


async function showCountMessage(bot, msg, variz) {
    var opts = {
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.input1)
    if (variz)
        bot.editMessageText('لطفا مبلغ فیش واریزی یا دریافتی را وارد نمایید.', opts)
    else

        bot.editMessageText('لطفا مقدار مورد نیاز را وارد نمایید.', opts)
}

async function showFeeMessage(bot, msg) {

    await db.updateStatus(msg, constant.input2)

    simpleMessage(bot, msg, 'لطفا مقدار قیمت ارز را وارد نمایید.')
}


async function forwardCurrencyMessage(bot, msg, data) {
    let arr = [{
        vahed: 'toman',
        text: 'تومان',
        callback_data: 'Rtoman_' + data.user
    },
        {
            vahed: 'dollar',
            text: 'دلار',
            callback_data: 'Rdollar_' + data.user
        },
        {
            vahed: 'euro',
            text: 'یورو',
            callback_data: 'Reuro_' + data.user
        },
        {
            vahed: 'lir',
            text: 'لیر',
            callback_data: 'Rlir_' + data.user
        },
        {
            vahed: 'aed',
            text: 'درهم',
            callback_data: 'Raed_' + data.user
        },
        {
            vahed: 'can',
            text: 'دلار کانادا',
            callback_data: 'Rcan_' + data.user
        },
        {
            vahed: 'pon',
            text: 'پوند',
            callback_data: 'Rpon_' + data.user
        },
        {
            vahed: 'aud',
            text: 'دلار استرالیا',
            callback_data: 'Raud_' + data.user
        },
        {
            vahed: 'rmb',
            text: 'یوان چین',
            callback_data: 'Rrmb_' + data.user
        }


    ]
    var opts = {
        reply_markup: {

            inline_keyboard: []
        }

    };

    for (let i = 0; i < arr.length; i++) {
        if (arr[i].vahed.includes(data.vahed))
            continue

        opts.reply_markup.inline_keyboard.push([{
            text: arr[i].text,
            callback_data: arr[i].callback_data
        }])

    }


    await await db.updateStatus(msg, constant.start)


    bot.sendMessage(msg.chat.id, 'لطفا نوع ارز بیس مبادله  را مشخص کنید.', opts)
}


async function sendDocMessage(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'بله',
                        callback_data: 'yes_' + user
                    }

                ],
                [

                    {
                        text: 'خیر',
                        callback_data: 'no_' + user
                    }

                ],


            ]
        }

    };
    await await db.updateStatus(msg, constant.input3)


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, 'آیا فیش همراه با فایل ضمیمه است؟', opts)
}


async function listRequest(bot, msg, reqs) {
    const opts = {
        reply_markup: {
            inline_keyboard: [],


        }
    };
    let print = "ℹ️ ";
    print += 'تعداد کل فیش ها: '
    print += reqs.length + "\n"


    reqs = reqs.reverse()
    for (let i = 0; i < reqs.length; i++) {

        let text = ''
        text += reqs[i].type.replace("variz", "واریز").replace("daryaft", "دریافت").replace("buy", "خرید").replace("sell", "فروش") + " "
        text += numberize(reqs[i].count) + " "
        text += reqs[i].unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم').replace('can', 'دلار کانادا').replace('pon', 'پوند').replace('aud', 'دلار استرالیا').replace('rmb', 'یوان چین') + " "
        if (reqs[i].type !== 'variz' && reqs[i].type !== 'daryaft' ) {
            text += 'با مبلغ '
            text += ' '
            text += numberize(reqs[i].fee)
            text += ' '
            text += reqs[i].toUnit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم').replace('can', 'دلار کانادا').replace('pon', 'پوند').replace('aud', 'دلار استرالیا').replace('rmb', 'یوان چین')
            text += ' '
        }

        if (reqs[i].file_id)
            text += '+عکس'


        opts.reply_markup.inline_keyboard.push([{
            text: text,
            callback_data: "reqs_" + reqs[i].id
        }])
    }
    await db.updateStatus(msg, constant.start)

    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, print, opts)
}


async function showDocument(bot, msg, req) {

    let d = await bot.downloadFile(req.file_id, 'img')
    return await bot.sendPhoto(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, d)
}


async function showRequest(bot, msg, req) {


    let text = ''
    if (req.type !== 'variz' && req.type !== 'daryaft') {

        text += 'تعداد '
        text += req.type.replace("sell", 'فروش').replace("buy", "خرید")
        text += ' '
        text += req.count
        text += ' '
        text += req.unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم').replace('can', 'دلار کانادا').replace('pon', 'پوند').replace('aud', 'دلار استرالیا').replace('rmb', 'یوان چین')
        text += ' '
        text += 'با مبلغ '
        text += ' '
        text += req.fee
        text += ' '
        text += req.toUnit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم').replace('can', 'دلار کانادا').replace('pon', 'پوند').replace('aud', 'دلار استرالیا').replace('rmb', 'یوان چین')
        text += ' '
    }
    else {

        text += ' واریز مبلغ '

        text += ' '
        text += req.count
        text += ' '
        text += req.unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم').replace('can', 'دلار کانادا').replace('pon', 'پوند').replace('aud', 'دلار استرالیا').replace('rmb', 'یوان چین')
        text += ' '
    }





    await await db.updateStatus(msg, constant.input3)


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, text)
    if (req.file_id !== null && req.file_id !== '')
        await showDocument(bot, msg, req)
}

function numberize(num)
{
    return numeral(num).format('0,0');
}


module.exports = {

    startMessage: startMessage,
    userShowMessage: userShowMessage,
    listUserMessage: listUserMessage,
    userSubmitRequest: userSubmitRequest,
    showCurrencyMessage: showCurrencyMessage,
    showCountMessage: showCountMessage,
    simpleMessage: simpleMessage,
    showFeeMessage: showFeeMessage,
    showCurrencyMessage: showCurrencyMessage,
    forwardCurrencyMessage: forwardCurrencyMessage,
    sendDocMessage: sendDocMessage,
    listRequest: listRequest,
    showRequest: showRequest,
    deleteMessage: deleteMessage
};

