const Sequelize = require('sequelize');
const moment = require('moment')
const Op = Sequelize.Op;


const dbAddress = process.env.DEBUG === 'true' ? process.env.HOST_Local : process.env.HOST_Server;
const dbPassword = process.env.DEBUG === 'true' ? 'root' : process.env.DB_PASS_SERVER;


const sequelize = new Sequelize('accounting', 'root', dbPassword, {
    define: {
        charset: 'utf8',
        charset: 'utf8',
        collate: 'utf8_general_ci'
    },
    host: dbAddress,
    dialect: 'mysql',
    logging: false,


    operatorsAliases: false
});


const User = sequelize.define('user', {
    first_name: Sequelize.STRING,
    last_name: Sequelize.STRING,
    pro: {type: Sequelize.BOOLEAN, allowNull: false, defaultValue: false},
    toman_balance: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},
    dollar_balance: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},
    euro_balance: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},
    lir_balance: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},
    aed_balance: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},


});


const Admin = sequelize.define('admin', {
    teleid: Sequelize.INTEGER,
    status: Sequelize.INTEGER,
    data: Sequelize.STRING


});


const Request = sequelize.define('request', {
    user_request: Sequelize.INTEGER,
    fee: Sequelize.DOUBLE,
    count: Sequelize.DOUBLE,
    unit: Sequelize.STRING,
    toUnit: Sequelize.STRING,
    is_today: Sequelize.BOOLEAN,
    file_id: Sequelize.STRING,
    type: Sequelize.STRING,

});


async function createRequest(data) {

    let user = await findUser(data.user)

    user = runCurrency(data, user)


    await updateBalance(user)

    let mRequest = await Request.create({
        user_request: data.user,
        fee: data.fee,
        count: data.count,
        unit: data.vahed,
        file_id: data.file_id,
        type: data.action,
        toUnit: data.to,
        is_today: true

    })
    return mRequest;


}

function runCurrency(data, user) {

    if (data.action === 'variz') {


        switch (data.vahed) {
            case 'toman':
                user.toman_balance = parseFloat(user.toman_balance) + (-1 * parseFloat(data.count))
                break
            case 'dollar':
                user.dollar_balance = user.dollar_balance + (-1 * parseFloat(data.count))
                break
            case 'euro':
                user.euro_balance = user.euro_balance + (-1 * parseFloat(data.count))
                break
            case 'lir':
                user.lir_balance = user.lir_balance + (-1 * parseFloat(data.count))
                break
            case 'aed':
                user.aed_balance = user.aed_balance + (-1 * parseFloat(data.count))
                break


        }

        return user
    }


    if (data.action === 'daryaft') {


        switch (data.vahed) {
            case 'toman':
                user.toman_balance = parseFloat(user.toman_balance) + (parseFloat(data.count))
                break
            case 'dollar':
                user.dollar_balance = user.dollar_balance + (parseFloat(data.count))
                break
            case 'euro':
                user.euro_balance = user.euro_balance + (parseFloat(data.count))
                break
            case 'lir':
                user.lir_balance = user.lir_balance + (parseFloat(data.count))
                break
            case 'aed':
                user.aed_balance = user.aed_balance + (parseFloat(data.count))
                break


        }

        return user
    }

    if (data.vahed === 'toman') {
        if (data.action === 'buy')
            user.toman_balance = user.toman_balance + parseFloat(data.count)
        else
            user.toman_balance = user.toman_balance + (-1 * parseFloat(data.count))


    }

    else if (data.vahed === 'dollar') {
        if (data.action === 'buy')
            user.dollar_balance = user.dollar_balance + parseFloat(data.count)
        else
            user.dollar_balance = user.dollar_balance + (-1 * parseFloat(data.count))

    }

    else if (data.vahed === 'euro') {
        if (data.action === 'buy')
            user.euro_balance = user.euro_balance + parseFloat(data.count)
        else
            user.euro_balance = user.euro_balance + (-1 * parseFloat(data.count))

    }

    else if (data.vahed === 'lir') {
        if (data.action === 'buy')
            user.lir_balance = user.lir_balance + parseFloat(data.count)
        else
            user.lir_balance = user.lir_balance + (-1 * parseFloat(data.count))

    }

    else if (data.vahed === 'aed') {
        if (data.action === 'buy')
            user.aed_balance = user.aed_balance + parseFloat(data.count)
        else
            user.aed_balance = user.aed_balance + (-1 * parseFloat(data.count))

    }


    if (data.to === 'toman') {
        if (data.action === 'buy')
            user.toman_balance = user.toman_balance + (-1 * parseFloat(data.count) * parseFloat(data.fee))
        else
            user.toman_balance = user.toman_balance + (parseFloat(data.count) * parseFloat(data.fee))


    }

    else if (data.vahed === 'dollar') {
        if (data.action === 'buy')
            user.dollar_balance = user.dollar_balance + (-1 * parseFloat(data.count) * parseFloat(data.fee))
        else
            user.toman_balance = user.dollar_balance + (parseFloat(data.count) * parseFloat(data.fee))


    }

    else if (data.vahed === 'euro') {
        if (data.action === 'buy')
            user.euro_balance = user.euro_balance + (-1 * parseFloat(data.count) * parseFloat(data.fee))
        else
            user.euro_balance = user.euro_balance + (parseFloat(data.count) * parseFloat(data.fee))


    }

    else if (data.vahed === 'lir') {
        if (data.action === 'buy')
            user.lir_balance = user.lir_balance + (-1 * parseFloat(data.count) * parseFloat(data.fee))
        else
            user.lir_balance = user.lir_balance + (parseFloat(data.count) * parseFloat(data.fee))


    }

    else if (data.vahed === 'aed') {
        if (data.action === 'buy')
            user.aed_balance = user.aed_balance + (-1 * parseFloat(data.count) * parseFloat(data.fee))
        else
            user.aed_balance = user.aed_balance + (parseFloat(data.count) * parseFloat(data.fee))


    }

    return user


}

async function getAllUsers() {


    return await User.findAll({
        raw: true
    })
}

async function getRequestByDate(userId, date) {


    return await Request.findAll({
        raw: true,
        where: {
            user_request: userId,
            createdAt: {
                [Op.gte]: moment().subtract(date, 'days').toDate()
            }

        }
    })
}


async function updateData(msg, data) {
    return await Admin.update(
        {
            data: data,


        },
        {where: {teleid: typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id}})

}


async function updateBalance(user) {
    return await User.update(
        {
            toman_balance: user.toman_balance,
            dollar_balance: user.dollar_balance,
            euro_balance: user.euro_balance,
            lir_balance: user.lir_balance,
            aed_balance: user.aed_balance


        },
        {where: {id: user.id}})

}

async function updateStatus(msg, status) {
    return await Admin.update(
        {
            status: status,


        },
        {where: {teleid: typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id}})

}

async function findUser(id) {
    return await User.findOne({raw: true, where: {id: id}})
}

async function findAdmin(msg) {
    return await Admin.findOne({
        raw: true,
        where: {teleid: typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id}
    })


}

async function findRequest(id) {
    return await Request.findOne({
        raw: true,
        where: {id: id}
    })
}


module.exports = {

    getAllUsers: getAllUsers,
    findUser: findUser,
    updateData: updateData,
    findAdmin: findAdmin,
    updateStatus: updateStatus,
    createRequest: createRequest,
    getRequestByDate: getRequestByDate,
    findRequest: findRequest
};
