const db = require('./db')
const constant = require('./const')

function startMessage(bot, msg) {
    simpleMessage(bot, msg, 'به ربات حسابداری خودش آمدید.')
}

async function simpleMessage(bot, msg, text) {
    const opts = {
        reply_markup: {
            keyboard: [
                ['💷 لیست اعضا'],


            ],
            resize_keyboard: true,
            one_time_keyboard: true

        }
    };


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, text, opts)
}

async function listUserMessage(bot, msg, users) {
    const opts = {
        reply_markup: {
            inline_keyboard: []


        }
    };

    for (let i = 0; i < users.length; i++) {

        let text = users[i].first_name + " " + users[i].last_name

        opts.reply_markup.inline_keyboard.push([{
            text: text,
            callback_data: "user_" + users[i].id
        }])
    }
    await db.updateStatus(msg, constant.start)

    bot.sendMessage(msg.chat.id, 'لطفا کاربر مورد نظر را انتخاب کنید.', opts)
}



async function deleteMessage(bot, msg) {
    await bot.deleteMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, typeof msg.message_id !== 'undefined' ? msg.message_id : msg.message.message_id)
}


function userShowMessage(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'ثبت فیش',
                        callback_data: 'request_' + user.id
                    }

                ]
                ,

                [

                    {
                        text: 'گزارش روزانه',
                        callback_data: 'reportD_' + user.id
                    }

                ]

                ,
                [

                    {
                        text: 'گزارش هفتگی',
                        callback_data: 'reportW_' + user.id
                    }

                ],
                [

                    {
                        text: 'گزارش ماهیانه',
                        callback_data: 'reportM_' + user.id
                    }

                ]
            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    let text = '💷 '
    text += Math.abs(user.toman_balance) + ' ' + 'تومان' + ' '
    text += user.toman_balance === 0 ? '' :
        user.toman_balance > 0 ? 'بدهکار' : 'طلبکار'

    text += '\n'
    text += '\n'

    if (user.dollar_balance !== 0) {
        text += '💵 '
        text += Math.abs(user.dollar_balance) + ' ' + 'دلار' + ' '
        text += user.dollar_balance === 0 ? '' :
            user.dollar_balance > 0 ? 'بدهکار' : 'طلبکار'

        text += '\n'
        text += '\n'
    }


    if (user.euro_balance !== 0) {
        text += '💶 '
        text += Math.abs(user.euro_balance) + ' ' + 'یورو' + ' '
        text += user.euro_balance === 0 ? '' :
            user.euro_balance > 0 ? 'بدهکار' : 'طلبکار'
        text += '\n'
        text += '\n'
    }

    if (user.lir_balance !== 0) {
        text += '💴 '
        text += Math.abs(user.lir_balance) + ' ' + 'لیر' + ' '
        text += user.lir_balance === 0 ? '' :
            user.lir_balance > 0 ? 'بدهکار' : 'طلبکار'

        text += '\n'
        text += '\n'
    }

    if (user.aed_balance !== 0) {

        text += '💰 ' + Math.abs(user.aed_balance) + ' ' + 'درهم' + " "
        text += user.aed_balance === 0 ? '' :
            user.aed_balance > 0 ? 'بدهکار' : 'طلبکار'
    }


    bot.editMessageText(text, opts)
}

async function showCurrencyMessage(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'تومان',
                        callback_data: 'toman_' + user.id
                    }

                ],
                [

                    {
                        text: 'دلار',
                        callback_data: 'dollar_' + user.id
                    }

                ],
                [

                    {
                        text: 'یورو',
                        callback_data: 'euro_' + user.id
                    }

                ],
                [

                    {
                        text: 'لیر',
                        callback_data: 'lir_' + user.id
                    }

                ],
                [

                    {
                        text: 'درهم',
                        callback_data: 'aed_' + user.id
                    }

                ]


            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.start)


    bot.editMessageText('لطفا نوع ارز را مشخص کنید.', opts)
}


async function userSubmitRequest(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'خرید',
                        callback_data: 'buy_' + user.id
                    }

                ]
                ,

                [

                    {
                        text: 'فروش',
                        callback_data: 'sell_' + user.id
                    }

                ],
                [

                    {
                        text: 'واریز',
                        callback_data: 'variz_' + user.id
                    }

                ],
                [

                    {
                        text: 'دریافت',
                        callback_data: 'daryaft_' + user.id
                    }

                ]


            ]
        },
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.start)


    bot.editMessageText('لطفا خرید یا فروش بودن معامله را مشخص کنید.', opts)
}


async function showCountMessage(bot, msg, variz) {
    var opts = {
        chat_id: msg.message.chat.id,
        message_id: msg.message.message_id
    };
    await db.updateStatus(msg, constant.input1)
    if (variz)
        bot.editMessageText('لطفا مبلغ فیش واریزی یا دریافتی را وارد نمایید.', opts)
    else

        bot.editMessageText('لطفا مقدار مورد نیاز را وارد نمایید.', opts)
}

async function showFeeMessage(bot, msg) {

    await db.updateStatus(msg, constant.input2)

    simpleMessage(bot, msg, 'لطفا مقدار قیمت ارز را وارد نمایید.')
}


async function forwardCurrencyMessage(bot, msg, data) {
    let arr = [{
        vahed: 'toman',
        text: 'تومان',
        callback_data: 'Rtoman_' + data.user
    },
        {
            vahed: 'dollar',
            text: 'دلار',
            callback_data: 'Rdollar_' + data.user
        },
        {
            vahed: 'euro',
            text: 'یورو',
            callback_data: 'Reuro_' + data.user
        },
        {
            vahed: 'lir',
            text: 'لیر',
            callback_data: 'Rlir_' + data.user
        },
        {
            vahed: 'aed',
            text: 'درهم',
            callback_data: 'Raed_' + data.user
        }


    ]
    var opts = {
        reply_markup: {

            inline_keyboard: []
        }

    };

    for (let i = 0; i < arr.length; i++) {
        if (arr[i].vahed.includes(data.vahed))
            continue

        opts.reply_markup.inline_keyboard.push([{
            text: arr[i].text,
            callback_data: arr[i].callback_data
        }])

    }


    await await db.updateStatus(msg, constant.start)


    bot.sendMessage(msg.chat.id, 'لطفا نوع ارز بیس مبادله  را مشخص کنید.', opts)
}


async function sendDocMessage(bot, msg, user) {
    var opts = {
        reply_markup: {

            inline_keyboard: [
                [

                    {
                        text: 'بله',
                        callback_data: 'yes_' + user
                    }

                ],
                [

                    {
                        text: 'خیر',
                        callback_data: 'no_' + user
                    }

                ],


            ]
        }

    };
    await await db.updateStatus(msg, constant.input3)


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, 'آیا فیش همراه با فایل ضمیمه است؟', opts)
}


async function listRequest(bot, msg, reqs) {
    const opts = {
        reply_markup: {
            inline_keyboard: [],


        }
    };
    let print = "ℹ️ ";
    print += 'تعداد کل فیش ها: '
    print += reqs.length + "\n"


    reqs = reqs.reverse()
    for (let i = 0; i < reqs.length; i++) {

        let text = ''
        text += reqs[i].type.replace("variz", "واریز").replace("daryaft", "دریافت").replace("buy", "خرید").replace("sell", "فروش") + " "
        text += reqs[i].count + " "
        text += reqs[i].unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم') + " "
        if (reqs[i].type !== 'variz' && reqs[i].type !== 'daryaft' ) {
            text += 'با مبلغ '
            text += ' '
            text += reqs[i].fee
            text += ' '
            text += reqs[i].toUnit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم')
            text += ' '
        }

        if (reqs[i].file_id)
            text += '+عکس'


        opts.reply_markup.inline_keyboard.push([{
            text: text,
            callback_data: "reqs_" + reqs[i].id
        }])
    }
    await db.updateStatus(msg, constant.start)

    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, print, opts)
}


async function showDocument(bot, msg, req) {

    let d = await bot.downloadFile(req.file_id, 'img')
    return await bot.sendPhoto(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, d)
}


async function showRequest(bot, msg, req) {


    let text = ''
    if (req.type !== 'variz' && req.type !== 'daryaft') {

        text += 'تعداد '
        text += req.type.replace("sell", 'فروش').replace("buy", "خرید")
        text += ' '
        text += req.count
        text += ' '
        text += req.unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم')
        text += ' '
        text += 'با مبلغ '
        text += ' '
        text += req.fee
        text += ' '
        text += req.toUnit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم')
        text += ' '
    }
    else {

        text += ' واریز مبلغ '

        text += ' '
        text += req.count
        text += ' '
        text += req.unit.replace('toman', 'تومان').replace('dollar', 'دلار').replace('euro', 'یورو').replace('lir', 'لیر').replace('aed', 'درهم')
        text += ' '
    }





    await await db.updateStatus(msg, constant.input3)


    bot.sendMessage(typeof msg.chat !== 'undefined' ? msg.chat.id : msg.message.chat.id, text)
    if (req.file_id !== null && req.file_id !== '')
        await showDocument(bot, msg, req)
}


module.exports = {

    startMessage: startMessage,
    userShowMessage: userShowMessage,
    listUserMessage: listUserMessage,
    userSubmitRequest: userSubmitRequest,
    showCurrencyMessage: showCurrencyMessage,
    showCountMessage: showCountMessage,
    simpleMessage: simpleMessage,
    showFeeMessage: showFeeMessage,
    showCurrencyMessage: showCurrencyMessage,
    forwardCurrencyMessage: forwardCurrencyMessage,
    sendDocMessage: sendDocMessage,
    listRequest: listRequest,
    showRequest: showRequest,
    deleteMessage: deleteMessage
};

