const Sequelize = require('sequelize');



const sequelize = new Sequelize('ai', 'root', 'mahan7797', {
    define: {
        charset: 'utf8',
        collate: 'utf8_general_ci'
    },
    host: 'db.zignaly.xyz',
    dialect: 'mysql',
    logging: false,



    operatorsAliases: false
});

const Account = sequelize.define('account', {
    name: Sequelize.STRING,
    equity: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0},
    qty: {type: Sequelize.DOUBLE, allowNull: false, defaultValue: 0.001},
    active: {type: Sequelize.BOOLEAN, allowNull: false, defaultValue: false},
    testnet: {type: Sequelize.BOOLEAN, allowNull: false, defaultValue: false},
    key: Sequelize.STRING,
    secret: Sequelize.STRING,


});

async function getAllAccounts() {


    return await Account.findAll({
        raw: true


    })

}

async function updateEquityByid(id, equity) {


    return await Account.update(
        {
            equity: equity,

        },
        {where: {id: id}})
}





sequelize.sync()


module.exports = {

    getAllAccounts:getAllAccounts,
    updateEquityByid:updateEquityByid

};
