let fs = require('fs')
var cors = require('cors')
const _ = require('lodash')
let express = require('express');
let moment = require('moment-timezone')

let app = express();
let files=[]
var bodyParser = require('body-parser')


let server = require('http').createServer(app);


let port = 80;
init()

app.use(cors())
app.use(bodyParser.text());
server.listen(port, () => {
    console.log('Server listening at port %d', port);


})





app.post('/signal', (req, res) => {

    res.send('Done')

    console.log(req.body)
    analyse(req.body)


})


async function init()
{
    files = await fs.readdirSync('E:\\YashilFinal')

}


async function analyse(body) {
    let t = body.split(',')
    let obj = {}
    obj.symbol = t[0]
    obj.entry = parseFloat(t[1])
    obj.exit = parseFloat(t[2])
    obj.side = t[3]
    obj.timeframe = t[4]
    obj.runUp = parseFloat(t[5])
    obj.drawDown = parseFloat(t[6])
    obj.profit = getPercent(obj.entry, obj.exit)
    obj.runUp = getPercent(obj.entry, (obj.runUp + obj.entry))
    obj.drawDown = getPercent(obj.entry, (obj.drawDown + obj.entry))
    obj.closeTime = moment().utc().format('YYYY.MM.DD HH:mm') + ':00.000'
    let indicator = ''
    for (let i = 7; i < t.length; i++) {
        indicator = indicator + t[i]
        if (i !== t.length - 1)
            indicator = indicator + '&'
    }
//Ticket,Open_Time,Type,Symbol,Open_Price,Close_Price,Close_Time,dPrfPipWrtOpPrPc,dAgeHiPrfInPrPc_RunUpPc,dAgeLoPrfInPrPc_DrawDownPc

    let final = '0,00:00,'
    if (obj.side === 'Long') {
        final = final + 'Buy'
        obj.side = 'Buy'
    } else {
        final = final + 'Sell'
        obj.side = 'Sell'
    }
    final = final + ',BTCUSDT,'

    final = final + obj.entry + ',' + obj.exit + ',' + obj.closeTime + ',' + obj.profit + ',' + obj.runUp + ',' + obj.drawDown
    //  let file = await fs.readFileSync('temp/' + indicator + '.csv', 'utf8')
    //  file = file.match(/.+/g)
    // console.log('try Check ',obj.side,file[file.length - 1])
    //  if (file.length > 2 && !file[file.length - 1].includes(obj.side))
    appendCsv(final, indicator)
    appendCsvtoMain(final,indicator)
}

function appendCsv(data, name) {
    fs.appendFile('temp/' + name + '.csv', data + '\n', function (err) {
        if (err) throw err;

    });
}


async function appendCsvtoMain(data, config) {


    config = config.replace('Kelt', 'btc4').replace('SOTT', 'btc3').replace('Pmax', 'btc2').replace('PPST', 'btc1').replace('.csv', '')
    for (let i = 0; i < files.length; i++) {

        if (files[i].startsWith(config + '_')) {
            appendtoFile(files[i],data)
        }
    }


}

function appendtoFile(name,data)
{
    fs.appendFile('E:\\YashilFinal\\'+name, data + '\n', function (err) {
        if (err) throw err;

    });
}

app.get('/', (req, res) => {

    res.send('Done')

    //console.log(req.body)


})

function getPercent(basePrice, value) {
    return ((value - basePrice) / basePrice) * 100
}






