let fs = require('fs')
let _ = require('lodash')
let moment = require('moment-timezone')
run()

async function run() {

    let configs = await fs.readdirSync('uniq/')
    let arr = []
    let arrDate = []
    let arrSide=[]
    let arrRunup=[]
    let levels = []
    let types = []

    for (let i = 0; i < configs.length; i++) {


        let config = await fs.readFileSync('./uniq/' + configs[i] + '/default/compound1000.json', 'utf8')
        config = JSON.parse(config)


        for (let j = 0; j < config.length; j++) {
            levels.push(config[j].maxLevel)
            types.push(config[j].type.split('targetPercentage:false')[1])
            let dateString = config[j].dateString.split('_')
            let sideString = config[j].sideString.split('_')
            let runUpString = config[j].runupString.split('_')

            for (let z = 0; z < dateString.length - 1; z++)
                arrDate.push(dateString[z])

            for (let z = 0; z < sideString.length - 1; z++)
                arrSide.push(sideString[z])
            for (let z = 0; z < runUpString.length - 1; z++)
                arrRunup.push(runUpString[z])
            arr.push(config[j])
        }


    }

    //  console.log(arr)

    arr = _.uniqBy(arr, 'platform');
    let allDates=arrDate
    arrDate = _.uniq(arrDate);
    let uniqLevels = _.uniq(levels);
    let uniqType = _.uniq(types);
    arrDate = _.orderBy(arrDate)
    let sides=['LONG','SHORT']

    let runUpunder1=0
    let runUpUnder11=0


    for (let i=0;i<arrRunup.length;i++)
    {
        if (arrRunup[i] <1)
            runUpunder1++
        if (arrRunup[i]<2)
            runUpUnder11++
    }

    console.log('Count of runUp<1 :'+runUpunder1)
    console.log('Count of runUp<2 :'+runUpUnder11)



   // await createfileADV()
    let levelSort = []
    let typeSort = []
    let sideSort=[]
    for (let i = 0; i < uniqLevels.length; i++) {
        let counter = 0
        for (let j = 0; j < levels.length; j++)
            if (uniqLevels[i] === levels[j])
                counter++
        levelSort.push({level: uniqLevels[i], count: counter})
    }

    for (let i = 0; i < uniqType.length; i++) {
        let counter = 0
        for (let j = 0; j < types.length; j++)
            if (uniqType[i] === types[j])
                counter++
        typeSort.push({type: uniqType[i], count: counter})
    }


    for (let i = 0; i < sides.length; i++) {
        let counter = 0
        for (let j = 0; j < arrSide.length; j++)
            if (sides[i] === arrSide[j])
                counter++
        sideSort.push({type: sides[i], count: counter})
    }



    typeSort = _.orderBy(typeSort, ['count'], ['desc']);
    console.log('All Uniq Platform:' + arr.length)
    console.log('All Uniq Date:' + arrDate.length)
  //  console.log(arrDate)
    console.log(levelSort)
   // console.log(typeSort)
    createConfileADV(typeSort)
    console.log(sideSort)
   // console.log(JSON.stringify(arrDate, null, 2))
    let arrDateSortCount=[]

    for (let i = 0; i < arrDate.length; i++) {
        let counter = 0
        for (let j = 0; j < allDates.length; j++)
            if (arrDate[i] === allDates[j])
                counter++
        arrDateSortCount.push({day: arrDate[i], count: counter})
    }


   createfileADV(JSON.stringify(arrDateSortCount, null, 2))
    let maxDiff = 0
    for (let i = 0; i < arrDate.length - 1; i++) {
        let diff = getDaysDiff(arrDate[i], arrDate[i + 1])
        if (diff > maxDiff)
            maxDiff = diff
    }
    console.log('Max Diff Day:' + maxDiff)
    let levelBaseDays = []

    for (let l = 0; l < uniqLevels.length; l++) {
        let levelInline = []
        for (let i = 0; i < configs.length; i++) {


            let config = await fs.readFileSync('./uniq/' + configs[i] + '/default/compound1000.json', 'utf8')
            config = JSON.parse(config)


            for (let j = 0; j < config.length; j++) {
                if (config[j].maxLevel === uniqLevels[l]) {
                    let dateString = config[j].dateString.split('_')

                    for (let z = 0; z < dateString.length - 1; z++)
                        levelInline.push(dateString[z])

                }

            }


        }
        levelInline = _.uniq(levelInline)
        levelBaseDays.push({level: uniqLevels[l], uniqDaysRun: levelInline.length})
    }

    console.log(levelBaseDays)


}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('date.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createConfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('con.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}