let moment = require('moment-timezone')
const fs = require('fs');

let plus = 'plus'
let zarib = 'zarib'
let base = 'base'


function run(data, config, risk, pfTrade, riskFreeLevel,detail) {
    let type=config.type + ' param:' + config.param + ' base:' + config.base + ' target:' + config.target
    let saveData=[]
    let needPrintData=shouldPrint(detail,data[0].signal+'&'+type)
   // console.log(needPrintData)

    let commision = config.commision
    let money = config.base
    let total = 0
    let allTotal=0
    let maxReserve = 0
    let maxAllocatedMoney = 0
    let maxLevel = 0
    //  console.log(data)

    let step = 0
    let reserv = 0
    let profit = 0
    let lastCom = 0
    let lastMoney = 0
    let levels = []

    let dur
    try {
        dur =getMinDiff(data[0].openDate, data[data.length - 1].closeDate)
    }
    catch (e)
    {
        return  null

    }

    if (dur <1300)
        return  null

    let newP = dur / data.length
    //  console.log(data.length)
    //  console.log(newP)
    if (pfTrade < newP)
        return null
    for (let i = 0; i < data.length; i++) {
let obj
        if (step === 0)
            money = config.base
        else {
            if (config.type === zarib)
                money = lastMoney * config.param
            if (config.type === base)
                money = config.base * config.param * step
            else if (config.type === plus)
                money = config.base * (step + 1)
        }
        let riskfree = false
        if (step > riskFreeLevel)
            riskfree = true
        let d = inlineCheck(money, commision, data[i], profit, lastCom, config.target,riskfree)


        if (Math.abs(d.reserve) > Math.abs(maxReserve))
            maxReserve = d.reserve

        //  console.log(maxAllocatedMoney)
        if (money > maxAllocatedMoney)
            maxAllocatedMoney = money

        //      console.log(data[i])
        //   console.log( 'step->'+step)
        //   console.log(d)



        if (step > maxLevel)
            maxLevel = step

        if  (needPrintData)
        {

            obj=d
            obj.openDate=data[i].openDate
            obj.closeDate=data[i].closeDate

            obj.maxReserve=maxReserve
            obj.maxAllocatedMoney=maxAllocatedMoney
            obj.maxLevel=maxLevel
            obj.step=step
            obj.money=money

        }
        if (d.done === true) {
            levels.push(step)
            step = 0
            reserv = 0
            profit = 0
            lastCom = 0
            lastMoney = 0
            allTotal++
            if (!d.riskFree)
            total++

        } else {
            step++
            profit = profit + d.profit
            lastMoney = d.lastMoney
            lastCom = lastCom + d.com

            if  (needPrintData)
            {

                obj.profit=profit
                obj.lastMoney=lastMoney
                obj.lastCom=lastCom


            }

        }

        if (needPrintData)
            saveData.push(obj)
    }
    let firstMaxAllocatedMoney = maxAllocatedMoney
    if (config.param !== 0) {
        for (let i = 0; i < risk; i++)
            maxAllocatedMoney = maxAllocatedMoney * config.param
    }

    let newLevel = []
    let newLevelText = ''
    for (let i = 0; i < (maxLevel + 1); i++) {
        let count = counter(i, levels)
        //   newLevel.push({level:i,count:count})
        let per = parseFloat((count / allTotal) * 100).toFixed(1)


        newLevelText = newLevelText + i + ':' + count + ':' + per + '%' + ','
        if ((i + 2) % 12 === 0) {

            newLevelText + newLevelText + '\\n'

        }


    }
    // console.log(newLevelText)

    //  for (let i=0;i<newLevel)


    let totalFinal = total * config.target
    let newT = totalFinal / dur
    let percentage = maxReserve + totalFinal
    percentage = maxAllocatedMoney / percentage
    let minus = 0
    if (percentage < 0) {
        minus = percentage
        percentage = null
    }

    let profitPerMonth = (newT * 30 * 100) / maxAllocatedMoney


    // let  percentage2 = maxReserve + newT
    //  percentage2 = maxAllocatedMoney / percentage2
    //  let minus2 = 0
    //  if (percentage2 < 0) {
    //       minus2 = percentage2
    //      percentage2 = null
    //  }

    let perp = (config.target * 100) / Math.abs(maxAllocatedMoney)
    perp = perp / 100

    let sum = Math.abs(maxAllocatedMoney)

    for (let i = 0; i < total; i++)
        sum = sum + (sum * perp)
    sum = sum - Math.abs(maxAllocatedMoney)
    let newCompund = sum / dur

    let compoundPerMonth = (newCompund * 30 * 100) / Math.abs(maxAllocatedMoney)

    let drawDown = Math.abs(((maxReserve * 100) / maxAllocatedMoney))
    let opt = {
        platform: data[0].signal,
        type: type,
        total: total,
        allTotal:allTotal,
        avgLevel: maxLevel / total,
        maxLevel: maxLevel,
        dur: dur,
        totalFinal: totalFinal,
        totalCompound: sum,
        profitPerMonth: Math.abs(profitPerMonth),
        compoundPerMonth: compoundPerMonth,

        firstMaxAllocatedMoney: firstMaxAllocatedMoney,
        maxAllocatedMoney: maxAllocatedMoney,

        avgAllocatedMoney: maxAllocatedMoney / total,
        drawDown: drawDown,
        CompoundPerMonthDrawDown: compoundPerMonth / drawDown,
        profitPerMonthDrawDown: Math.abs(profitPerMonth) / drawDown,
        maxReseve: maxReserve,
        avgReserve: maxReserve / total,
        percentage: percentage,
        avgProfitPerDay: newT,
        allocatedReserve: (maxAllocatedMoney) / Math.abs(maxReserve),
        minus: minus,
        risk: risk,
        levels: newLevelText,
        pftrade: newP,
        countOfTrade: data.length


    }

    if (needPrintData)
    {
        fs.writeFile('detail/'+data[0].signal, JSON.stringify(saveData, null, 2), 'utf8', function (err) {

        });
    }



    return opt


    // console.log(data)
}


function counter(count, array) {
    let sum = 0
    for (let i = 0; i < array.length; i++)
        if (array[i] === count)
            sum++

    return sum

}

function percentage2(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return base + temp
}


function inlineCheck(money, com, data, profit, lastCom, tar,riskFree) {
    //  console.log(profit)

    com = com * money

    let target = money + Math.abs(profit) + com + lastCom

    if (!riskFree)
        target=target+tar

    let reserve = percentage(money, data.drawDown)

    let profitMoney = percentageMinus(money, data.profit)

    let diff = reserve - money
    diff = diff - com - lastCom + profit

    //  console.log('reserve->'+reserve + ' money->'+money +' com->'+com +' lastCom->'+lastCom + 'profit->'+profit  +' diff->'+diff)


    if (percentage(money, data.runUp) > target)
        return {done: true, reserve: diff,riskFree}
    else
        return {done: false, reserve: diff, profit: profitMoney, com: com, lastMoney: money}


}


function calPer(entry, last) {
    return ((last - entry) / entry) * 100
}

function shouldPrint(details,type)
{
    for (let i=0;i<details.length;i++)
    {
        if (details[i] ===type)
            return true
    }

    return false
}

function percentage(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return base + temp
}

function percentageMinus(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return temp
}

function getMinDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed).tz('Asia/Tehran').format());
    var end = moment.duration(now.diff(moment(start).tz('Asia/Tehran')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}


module.exports =
    {

        run: run,


    }