let fs=require('fs')
let _=require('lodash')
var shell = require('shelljs');
let prefix='work'
let cores=15


init()



async function init()
{


    for (let i=0;i<cores;i++)
    {
        let res=await fs.existsSync(prefix+i)
        if (!res) {
           await fs.mkdirSync(prefix + i)

        }
        makeStatus(prefix + i)
    }


    check()



}

function makeStatus(directory) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory+'/work'+'.txt', '0', 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}



async function check()
{
    let files=await fs.readdirSync('files')
    for (let i=0;i<files.length;i++)
    {
        if (!files[i].includes('csv'))
            continue

        let worker=await findOffWorker()
        console.log(worker)
        await fs.renameSync('files/'+files[i],worker+'/'+files[i])
        shell.exec('node run.js '+worker, {async: true});

    }


    return check()



  //  console.log(files)
}



async function findOffWorker()
{
    let arr=[]
    for (let i=0;i<cores;i++)
    {
        let res = await fs.readFileSync('./'+prefix+i+'/work.txt', 'utf8');
        if (res.includes('0'))
            arr.push(prefix+i)

    }
    arr=_.shuffle(arr)
    if (arr.length !==0)
        return arr[0]

}