let fs = require('fs')
let csv = require('./csv')
let _ = require('lodash')
let directory
let configFileName
let csvFile
let checks = []
let candles
let drawDown = [30, 40, 50]
//const perf = require('execution-time')();
run()

async function run() {
    var args = process.argv.slice(2);
    directory = args[0]
    configFileName = args[1]
    checks = args[2]
    await makeStatus(directory, '1')
    //  perf.start()
    candles = await fs.readFileSync('./csv/coin.csv', 'utf8')
    // let end=candles.split('\n')
    candles=candles.match(/.+/g)
    let arr5=[]
    for (let i=1;i<candles.length;i++)
    {
        let t=candles[i].split(',')
        arr5.push({t:parseFloat(t[0]),o:parseFloat(t[1]),h:parseFloat(t[2]),l:parseFloat(t[3]),c:parseFloat(t[4])})
    }
//candles=candles.replace('time,open,high,low,close','')
   // candles=candles=candles.split('\n')
   // await sleep(2000)
   // console.log(arr5)
   // await sleep(500)
  //  console.log(candles.length)

 // console.log(candles.length)
    let configs = await fs.readFileSync('./configs/' + configFileName, 'utf8')
    checks = await fs.readFileSync('./detail.json', 'utf8')
    configs = JSON.parse(configs)
    let arr = []
    let files = await fs.readdirSync('./work/' + directory)
   // console.log(files)

    for (let i = 0; i < files.length; i++)
        if (files[i].includes('.csv')) {
            csvFile = files[i]
            arr.push(csv.parse(directory, files[i], configs.data, configs.risk, configs.pfTrade, configs.side, configs.riskFreeLevel, JSON.parse(checks), configs.onlyShortLong, configs.loss,configs.dur,configs.maxTradeDays,configs.targetPercentage,arr5,configs.fft,configs.ProfitZeroProfit,configs.fftRunup,configs.ProfitZeroProfitRunup,configs.ProfitZeroDrawDownProfit,configs.usage))
        }

    arr = await Promise.all(arr)

    let count = 0
    let arr2 = []
    let arr3 = []
  //  console.log(arr)
    for (let i = 0; i < arr.length; i++) {
        let inline = arr[i]
        for (let j = 0; j < inline.length; j++) {
             if (inline[j].maxLevel < configs.level)
                arr2.push(inline[j])


        }
    }

    arr2 = _.without(arr2, undefined, null);





    arr2 = _.orderBy(arr2, ['profitPerMonthDrawDown'], ['desc']);
    let arrMaxTime=_.orderBy(arr2, ['maxRuntime']);
    let arr20Max = []
    let arr1000Compound = []

    let arrReserv = _.orderBy(arr2, ['percentage'], ['asc']);
    let arrCompound = _.orderBy(arr2, ['maxLevel'], ['desc']);
    let arrResrv200 = []
    let arr1000Maxtime=[]
    let arrReservCompound = []
    for (let i = 0; i < 1000; i++) {
        if (typeof arr2[i] !== "undefined")
            arr3.push(arr2[i])
        if (typeof arrReserv[i] !== "undefined")
            arrResrv200.push(arrReserv[i])
        if (typeof arrCompound[i] !== "undefined")
            arr1000Compound.push(arrCompound[i])
        if (typeof arrMaxTime[i] !== "undefined")
            arr1000Maxtime.push(arrMaxTime[i])

    }


    let arr20MaxNew = []
    let arrReservCompoundNew = []
    for (let i = 0; i < 1000; i++) {
        if (typeof arr20Max[i] !== "undefined")
            if (i < arr20Max.length)
                arr20MaxNew.push(arr20Max[i])
        if (typeof arrReservCompound[i] !== "undefined")
            if (i < arrReservCompound.length)
                arrReservCompoundNew.push(arrReservCompound[i])

    }


    let timestamp = Date.now()
    try {

        await fs.mkdirSync('result/' + configFileName + '/' + csvFile)
        await fs.mkdirSync('result/' + configFileName + '/' + csvFile + '/default')
        // await fs.mkdirSync('result/' + csvFile+'/drawDown30')
        // await fs.mkdirSync('result/' + csvFile+'/drawdown40')
        // await fs.mkdirSync('result/' + csvFile+'/drawdown50')
    } catch (e) {

    }

    await fs.unlinkSync('work/'+directory + '/' + csvFile)
    // createfileADV('allDataSortedByProfit', JSON.stringify(arr2, null, 2))
  //  createfileADV('default', 'profitPerMonth1000', JSON.stringify(arr3, null, 2))

    createfileADV('default', 'compound1000', JSON.stringify(arr1000Compound, null, 2))
  //  createfileADV('default', 'maxtime1000', JSON.stringify(arr1000Maxtime, null, 2))

    arr20Max = []
    for (let i = 0; i < arr2.length; i++) {

        if (arr2[i].allocatedReserve < 2)
            arr20Max.push(arr2[i])
    }
    arrCompound = []
    for (let i = 0; i < arrCompound.length; i++) {

        if (arrCompound[i].allocatedReserve < 2)
            arrReservCompound.push(arrCompound[i])
    }
    arr20MaxNew = []
    arrReservCompoundNew = []
    for (let i = 0; i < 1000; i++) {
        if (i < arr20Max.length)
            arr20MaxNew.push(arr20Max[i])

        if (i < arrReservCompound.length)
            arrReservCompoundNew.push(arrReservCompound[i])

    }
    // createfileADV('allocatedReservePerMonthUnder2', JSON.stringify(arr20MaxNew, null, 2))
    // createfileADV('allocatedReserveCompoundUnder2' , JSON.stringify(arrReservCompoundNew, null, 2))

  //  startAgain(arr, configs.start, configs.level)
    //  generateBaseDrawDown(arr2)
    //   generateDrawDownBaseStart(arr2,configs.start)
    console.log('Done')
    await makeStatus(directory, '0')
    //   process.exit(0)
    // console.log(d)
}

async function generateBaseDrawDown(arrLast) {

    for (let z = 0; z < drawDown.length; z++) {
        let arr2 = arrLast
        let newArr = []

        for (let i = 0; i < arr2.length; i++) {
            //  console.log(arr2[i].drawDown)
            if (arr2[i].drawDown >= drawDown[z])
                newArr.push(arr2[i])
        }

        arr2 = newArr

        arr2 = _.orderBy(arr2, ['profitPerMonthDrawDown'], ['desc']);
        let arr20Max = []
        let arr1000Compound = []
        let arr3 = []

        let arrReserv = _.orderBy(arr2, ['percentage'], ['asc']);
        let arrCompound = _.orderBy(arr2, ['CompoundPerMonthDrawDown'], ['desc']);
        let arrResrv200 = []
        let arrReservCompound = []
        for (let i = 0; i < 1000; i++) {
            if (typeof arr2[i] !== "undefined")
                arr3.push(arr2[i])
            if (typeof arrReserv[i] !== "undefined")
                arrResrv200.push(arrReserv[i])
            if (typeof arrCompound[i] !== "undefined")
                arr1000Compound.push(arrCompound[i])
        }


        let arr20MaxNew = []
        let arrReservCompoundNew = []
        for (let i = 0; i < 1000; i++) {
            if (typeof arr20Max[i] !== "undefined")
                if (i < arr20Max.length)
                    arr20MaxNew.push(arr20Max[i])
            if (typeof arrReservCompound[i] !== "undefined")
                if (i < arrReservCompound.length)
                    arrReservCompoundNew.push(arrReservCompound[i])

        }


        createfileADV('drawDown' + drawDown[z], 'profitPerMonth1000DrawDown' + drawDown[z], JSON.stringify(arr3, null, 2))
        createfileADV('drawDown' + drawDown[z], 'compound1000DrawDown' + drawDown[z], JSON.stringify(arr1000Compound, null, 2))


    }
}

async function generateDrawDownBaseStart(arrLast, start) {
    for (let z = 0; z < drawDown.length; z++) {

        let arr2 = arrLast
        let newArr = []
        let arr3 = []
        for (let i = 0; i < arr2.length; i++) {
            //  console.log(arr2[i].drawDown)
            if (arr2[i].drawDown >= drawDown[z] && arr2[i].maxAllocatedMoney < start)
                newArr.push(arr2[i])
        }
        //   console.log(arr2)
        arr2 = newArr
        arr2 = _.without(arr2, undefined, null);
        arr2 = _.orderBy(arr2, ['profitPerMonthDrawDown'], ['desc']);
        let arr20Max = []
        let arr1000Compound = []

        let arrReserv = _.orderBy(arr2, ['percentage'], ['asc']);
        let arrCompound = _.orderBy(arr2, ['CompoundPerMonthDrawDown'], ['desc']);
        let arrResrv200 = []
        let arrReservCompound = []
        for (let i = 0; i < 1000; i++) {
            if (typeof arr2[i] !== "undefined")
                arr3.push(arr2[i])
            if (typeof arrReserv[i] !== "undefined")
                arrResrv200.push(arrReserv[i])
            if (typeof arrCompound[i] !== "undefined")
                arr1000Compound.push(arrCompound[i])
        }


        let arr20MaxNew = []
        let arrReservCompoundNew = []
        for (let i = 0; i < 1000; i++) {
            if (typeof arr20Max !== "undefined")
                if (i < arr20Max.length)
                    arr20MaxNew.push(arr20Max[i])

            if (typeof arrReservCompound !== "undefined")
                if (i < arrReservCompound.length)
                    arrReservCompoundNew.push(arrReservCompound[i])

        }


        // await fs.unlinkSync(directory + '/' + csvFile)
        // createfileADV('allDataSortedByProfit', JSON.stringify(arr2, null, 2))
        createfileADV('drawDown' + drawDown[z], 'profitPerMonth1000StartDrawDown' + drawDown[z], JSON.stringify(arr3, null, 2))
        //   createfileADV('percentage1000', JSON.stringify(arrResrv200, null, 2))
        createfileADV('drawDown' + drawDown[z], 'compound1000StartDrawDown' + drawDown[z], JSON.stringify(arr1000Compound, null, 2))
        //  createfileADV('allocatedReservePerMonthUnder3', JSON.stringify(arr20MaxNew, null, 2))
        //  createfileADV('allocatedReserveCompoundUnder3' , JSON.stringify(arrReservCompoundNew, null, 2))

    }
}


async function startAgain(arr, start, level) {
    let count = 0
    let arr2 = []
    let arr3 = []
    for (let i = 0; i < arr.length; i++) {
        let inline = arr[i]
        inline = _.without(inline, undefined, null);
        for (let j = 0; j < inline.length; j++) {
            if (inline[j].maxAllocatedMoney < start && inline[j].maxLevel < level)
                arr2.push(inline[j])


        }
    }
    //   console.log(arr2)
    arr2 = _.without(arr2, undefined, null);
    arr2 = _.orderBy(arr2, ['profitPerMonthDrawDown'], ['desc']);
    let arr20Max = []
    let arr1000Compound = []

    let arrReserv = _.orderBy(arr2, ['percentage'], ['asc']);
    let arrCompound = _.orderBy(arr2, ['CompoundPerMonthDrawDown'], ['desc']);
    let arrResrv200 = []
    let arrReservCompound = []
    for (let i = 0; i < 1000; i++) {
        if (typeof arr2[i] !== "undefined")
            arr3.push(arr2[i])
        if (typeof arrReserv[i] !== "undefined")
            arrResrv200.push(arrReserv[i])
        if (typeof arrCompound[i] !== "undefined")
            arr1000Compound.push(arrCompound[i])
    }

    // for (let i = 0; i < arr2.length; i++) {
    //
    //     if (arr2[i].allocatedReserve < 3)
    //         arr20Max.push(arr2[i])
    // }


    // for (let i = 0; i < arrCompound.length; i++) {
    //
    //     if (arrCompound[i].allocatedReserve < 3)
    //         arrReservCompound.push(arrCompound[i])
    // }

    let arr20MaxNew = []
    let arrReservCompoundNew = []
    for (let i = 0; i < 1000; i++) {
        if (typeof arr20Max !== "undefined")
            if (i < arr20Max.length)
                arr20MaxNew.push(arr20Max[i])

        if (typeof arrReservCompound !== "undefined")
            if (i < arrReservCompound.length)
                arrReservCompoundNew.push(arrReservCompound[i])

    }


    // await fs.unlinkSync(directory + '/' + csvFile)
    // createfileADV('allDataSortedByProfit', JSON.stringify(arr2, null, 2))
    createfileADV('default', 'profitPerMonth1000Start', JSON.stringify(arr3, null, 2))
    //   createfileADV('percentage1000', JSON.stringify(arrResrv200, null, 2))
    createfileADV('default', 'compound1000Start', JSON.stringify(arr1000Compound, null, 2))
    //  createfileADV('allocatedReservePerMonthUnder3', JSON.stringify(arr20MaxNew, null, 2))
    //  createfileADV('allocatedReserveCompoundUnder3' , JSON.stringify(arrReservCompoundNew, null, 2))


}

function createfile(data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/result.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createfileADV(type, filename, data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('result/' + configFileName + '/' + csvFile + '/' + type + '/' + filename + '.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}


function createfile2(data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/profitPerMonth1000.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}


async function test2() {
    let configs = await fs.readFileSync('./configTemp.json', 'utf8')
    configs = JSON.parse(configs)
    console.log(configs)
}


function makeStatus(directory, status) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('work/'+directory + '/work' + '.txt', status, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}



