let pair = 'ETHUSDT'
let timeframe = '5m'
const Downloader = require("nodejs-file-downloader");
const extract = require('extract-zip')
var shell = require('shelljs');
const fs=require('fs')


run()


async function run() {
    try {
        await fs.mkdirSync('ohlc')
    } catch (e) {

    }

    try {
        await fs.mkdirSync('ohlc/' + pair)
    } catch (e) {

    }
let arr=[]
    for (let i = 2017; i <= 2022; i++) {
        arr.push(monthlyDownloader(i))
    }

    await Promise.all(arr)

    await sleep(4000)
    console.log('try ReadFiles')

    readFiles()


}

async function readFiles()
{
    let configs = await fs.readdirSync('ohlc/'+pair)
    let arr=[]
    for (let i=0;i<configs.length;i++)
    {
        if (!configs[i].includes('.csv'))
            continue

        console.log(configs[i])

        let file = await fs.readFileSync('./ohlc/'+pair+'/'+configs[i], 'utf8')
        file = file.match(/.+/g)
        for (let j=0;j<file.length;j++)
        {
            let temp=file[j].split(',')
            let obj={}
            obj.timestamp=parseInt(temp[0])/1000
            obj.open=temp[1]
            obj.high=temp[2]
            obj.low=temp[3]
            obj.close=temp[4]

            arr.push(obj)


        }

    }
    await write(arr)
   // console.log(configs)
}

async function write(data)
{
//console.log(data)
    let t='time,open,high,low,close\n'
    for (let i=0;i<data.length;i++)
    {
        t+=data[i].timestamp+','+data[i].open+','+data[i].high+','+data[i].low+','+data[i].close+'\n'
    }
   // console.log(t)
await removeAll()
   createfileADV(t)

}

function createfileADV(data) {
   // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('ohlc/'+pair+'/'+pair+'-'+timeframe+'.csv', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

async function monthlyDownloader(year) {
    for (let i = 1; i <= 12; i++) {
        let temp = i
        if (i < 10)
            temp = '0' + i
        await download(year, temp)

    }


}

//testUnzip()
async function unzip(filename) {

    try {
        let command = 'cd ohlc/' + pair
        command = command + '  && extract-zip ' + filename
        console.log(command)
        await shell.exec(command, {async: true});
        await sleep(1000)
        console.log('Extraction ' + filename + ' completed')

    } catch (err) {
        console.log(err)

    }
}

async function removeAll()
{
    let command = 'cd ohlc/' + pair
    command = command + '  && rm -r *'

    await shell.exec(command, {async: true});
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


async function download(year, month) {
    let fileName = pair + '-' + timeframe + '-' + year + '-' + month + '.zip'
    let link = 'https://data.binance.vision/data/spot/monthly/klines/' + pair + '/' + timeframe + '/' + fileName
    console.log(link)
   // console.log(link)
    const downloader = new Downloader({
        url: link,
        directory: "./ohlc/" + pair,
    });
    try {
        console.log('try download ' + pair + ' ' + year + '/' + month)
        await downloader.download();

        await unzip(fileName)


        //console.log("done");
    } catch (error) {

        console.log("Not found " + year + '/' + month);
    }
}