const fs = require('fs')
let moment = require('moment-timezone')
let _ = require('lodash')
const uuid = require('uniqid')
let pairs = ''

let files = []
init()


async function init() {


    let com = await fs.readFileSync('raw.json', 'utf8');

    com = JSON.parse(com)
    let arr=[]
    for (let i=0;i<com.length;i++)
    {
        let plat=com[i].platform.split('_')
        let value=parseFloat(plat[plat.length-1])
        let config=plat[plat.length-2]
        let last=config + ' ' + value*-1
        let type=com[i].type.split(' ')
        type =type[type.length-2] +' '+parseFloat(type[type.length-1])
        console.log(type)
        if (type === last) {
            //console.log(com[i])
            arr.push(com[i])
        }

    }
    createRawNew(JSON.stringify(arr, null, 2))
 //   console.log(arr.length)

}

async function append(config, data) {
    console.log(config + '_')

    for (let i = 0; i < files.length; i++) {
        if (files[i].includes(config))
            console.log(files[i])
        if (files[i].startsWith(config + '_')) {
            //  console.log(config,files[i])
            console.log(files[i])
            for (let j = 0; j < data.length; j++)
                appender(files[i], data[j])
        }
    }
}

async function appender(file, data) {
//console.log(data)
    fs.appendFile('E:\\YashilFinal\\' + file, data + '\n', function (err) {
        if (err) throw err;

    });

}

async function renamer(config, newName) {

    for (let i = 0; i < files.length; i++) {
        if (files[i].includes('Lp1_' + config))
            await fs.renameSync('E:\\YashilFinal\\' + files[i], 'E:\\YashilFinal\\' + config + '_' + newName + '.csv')

    }
}

async function remover(config, newName) {

    for (let i = 0; i < files.length; i++) {

        if (files[i].startsWith(config + '_')) {
            let file = await fs.readFileSync('E:\\YashilFinal\\' + files[i], 'utf8')
            file = file.split('\n')
            //console.log(file)
            let arr = []
            for (let j = 0; j < file.length - 2; j++)
                arr.push(file[j])
            // console.log(arr)
            let t = ''
            for (let j = 0; j < arr.length; j++) {
                t = t + arr[j]
                if (j !== arr.length - 1)
                    t = t + '\n'
            }
            await createYAshil(files[i], t)


        }

    }
}

function isUpper(str) {
    return !/[a-z]/.test(str) && /[A-Z]/.test(str);
}

function capital(t) {
    let f = ''
    for (let j = 0; j < t.length; j++)
        if (isUpper(t[j]))
            f = f + t[j]

    return f
}

function createRunResfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile(pairs + '_TOP.csv', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}


function createYAshil(name, data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('E:\\YashilFinal\\' + name, data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function found(indicator, pair, lp) {
    // console.log(indicator,lp)
    let res = []

    if (indicator === 2)
        res = res2
    else if (indicator === 3)
        res = res3
    else if (indicator === 4)
        res = res4

    if (res.length === 0)
        return {timeframe: 0}
    for (let i = 0; i < res.length; i++) {
        if (!res[i].includes(lp + '_'))
            continue


        let d = res[i].split(',')
        let timeframe = d[13]
        timeframe = timeframe.split(' ')
        let newTimeframe = '0d '
        for (let z = 1; z < timeframe.length; z++) {
            newTimeframe = newTimeframe + timeframe[z]
            if (z !== timeframe.length - 1)
                newTimeframe = newTimeframe + ' '
        }

        if (indicator === 2)
            return {timeframe: newTimeframe, nAtrPeriod: d[15], dAtrMultiplier: d[17]}
        if (indicator === 3)
            return {timeframe: newTimeframe, nStochPeriod: d[15], nStochSmoothingPeriod: d[16], dOttPercent: d[18]}
        if (indicator === 4)
            return {timeframe: newTimeframe, nMidLnMaPeriod: d[14], dMultiplier: d[15]}

        // timeframe=newTimeframe
        // let nStochPeriod=parseFloat(d[15])
        // let nStochSmoothingPeriod=parseFloat(d[16])
        // let dOttPercent=parseFloat(d[18])
        //
        // let name = d[92]

        // return {name, timeframe, nStochPeriod, nStochSmoothingPeriod, dOttPercent}
        return {timeframe}

    }
}

function createConfigYashilADV(name, data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('YConfig/' + name + '.txt', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createRawNew(data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('raw-last.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}




