let moment = require('moment-timezone')


let plus = 'plus'
let zarib = 'zarib'
let base='base'


function run(data, config) {
    let commision = config.commision
    let money = config.base
    let total = 0
    let maxReserve = 0
    let maxAllocatedMoney = 0
    let maxLevel = 0
    //  console.log(data)

    let step = 0
    let reserv = 0
    let profit = 0
    let lastCom = 0
    let lastMoney=0
    for (let i = 0; i < data.length; i++) {

        if (step === 0)
            money = config.base
        else {
            if  (config.type === zarib)
                money=lastMoney * config.param
            if (config.type === base)
                money = config.base * config.param * step
            else if (config.type === plus)
                money = config.base *(step+1)
        }

        let d = inlineCheck(money, commision, data[i], profit, lastCom,config.target)


        if (Math.abs(d.reserve) > Math.abs(maxReserve))
            maxReserve = d.reserve

      //  console.log(maxAllocatedMoney)
        if (money > maxAllocatedMoney)
            maxAllocatedMoney = money

        //      console.log(data[i])
        //   console.log( 'step->'+step)
        //   console.log(d)

        if (step > maxLevel)
            maxLevel = step
        if (d.done === true) {
            step = 0
            reserv = 0
            profit = 0
            lastCom = 0
            lastMoney=0
            total++

        } else {
            step++
            profit = profit + d.profit
            lastMoney=d.lastMoney
            lastCom = lastCom + d.com

        }
    }




    let dur = getMinDiff(data[0].openDate, data[data.length - 1].closeDate)
    let totalFinal=total* config.target
    let newT=totalFinal/dur
    let percentage = maxReserve + totalFinal
     percentage = maxAllocatedMoney / percentage
    let minus = 0
    if (percentage < 0) {
        minus = percentage
        percentage = null
    }

    let profitPerMonth=(newT * 30 * 100)/maxReserve


   // let  percentage2 = maxReserve + newT
   //  percentage2 = maxAllocatedMoney / percentage2
   //  let minus2 = 0
   //  if (percentage2 < 0) {
   //      minus2 = percentage2
   //      percentage2 = null
   //  }

    let opt = {
        platform: data[0].signal,
        type: config.type + ' param:' + config.param + ' base:' + config.base +' target:'+config.target,
        total: total,
        avgLevel: maxLevel / total,
        maxLevel: maxLevel,
        dur:dur,
        totalFinal:totalFinal,

        profitPerMonth:Math.abs(profitPerMonth),
        maxAllocatedMoney: maxAllocatedMoney,
        avgAllocatedMoney: maxAllocatedMoney / total,

        maxReseve: maxReserve,
        avgReserve: maxReserve / total,
        percentage: percentage,
        avgProfitPerDay:newT,
        allocatedReserve:(maxAllocatedMoney)/Math.abs(maxReserve),
        minus: minus,



    }


    return opt


    // console.log(data)
}


function inlineCheck(money, com, data, profit, lastCom,tar) {
    //  console.log(profit)

    com = com * money

    let target = money + Math.abs(profit) + com + lastCom + tar

    let reserve = percentage(money, data.drawDown)

    let profitMoney = percentageMinus(money, data.profit)

    let diff = reserve - money
    diff = diff - com - lastCom + profit

    //  console.log('reserve->'+reserve + ' money->'+money +' com->'+com +' lastCom->'+lastCom + 'profit->'+profit  +' diff->'+diff)


    if (percentage(money, data.runUp) > target)
        return {done: true, reserve: diff}
    else
        return {done: false, reserve: diff, profit: profitMoney, com: com,lastMoney:money}


}


function calPer(entry, last) {
    return ((last - entry) / entry) * 100
}

function percentage(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return base + temp
}

function percentageMinus(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return temp
}

function getMinDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed).tz('Asia/Tehran').format());
    var end = moment.duration(now.diff(moment(start).tz('Asia/Tehran')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}


module.exports =
    {

        run: run,


    }