let fs = require('fs')
var watch = require('node-watch');
let ai = require('./ai-new')
let path = 'C:\\yMTa - 2\\Set\\AltTest2\\'
let longSide = 'LONG'
let shortSide = 'SHORT'
let bybit = require('./test_bybit')
let zignaly = require('./zignaly')
let redis = require('redis')
const client = redis.createClient(
    {url: 'redis://default:p@db.zignaly.xyz:7001'}
);
let datas = []
let balance = 0


const ccxt = require('ccxt')


let  exchange
let info




init()



async function init() {
    client.on('error', (err) => console.log('Redis Client Error', err));

    await client.connect();
     info = await fs.readFileSync('info2.json', 'utf8');
    info=JSON.parse(info)
    exchange= new ccxt.bybit({
        apiKey: info.apiKey,
        secret: info.secret,
        enableRateLimit: true,

    })

   // exchange.urls['api'] = exchange.urls['test'];

    run()
    balanceUpdater() 
}


async function balanceUpdater() {
    try {
        let d = await exchange.fetchFreeBalance()
        if (d.USDT !==balance)
        {
            balance = d.USDT
            appendBalanceProfitLog(balance)
        }

    } catch (e) {

    }
    await sleep(60000)
    return balanceUpdater()
}


async function run() {
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {
        if (!files[i].includes('Lp'))
            continue

        let fl = files[i].split('_')
        let pair = fl[fl.length - 1].replace('.csv','')+'USDT'
        console.log(pair)
        let avgRunup = parseFloat(fl[5])
        let avgDrawDown = parseFloat(fl[6])
        let lastFile = await fs.readFileSync(path + files[i], 'utf8')
        let stats = await fs.statSync(path + files[i])
        lastFile = lastFile.split('\n')
        // console.log(lastFile[lastFile.length - 2])

        let data = grabData(lastFile)


        let vars = ai.run(data, avgRunup, avgDrawDown)
        let sp = files[i].split('_')
        let id = sp[4]
        let usage = sp[7]
        let value = parseFloat(sp[8])
        let qty = parseFloat(sp[9])
//console.log(vars.VarProfitDrawDownZeroProfit)
        datas.push({
            name: files[i],
            size: stats.size,
            pair: pair,
            vars: vars,
            id: id,
            usage: usage,
            value: (-1 * value),
            avgRunup: avgRunup,
            avgDrawDown: avgDrawDown,
            qty: qty
        })
    }

    //  console.log(datas)


    //  console.log(datas)
    checker()

}


function grabData(data) {
    // console.log(data)
    let arr = []
    for (let i = 0; i < data.length; i++) {


        try {
            let d = data[i].split(',')
            let profit = parseFloat(d[7])
            let runUp = parseFloat(d[8])
            let drawDown = parseFloat(d[9])
            let t = d[6]
            t = t.split(':')
            let closeTime = t[0] + ':' + t[1]

            if (isNaN(profit))
                continue
            arr.push({profit, runUp, drawDown, closeTime})
        } catch (e) {

        }

    }

    return arr
}


async function checker() {
    let arr = []
    //  console.log('check')
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {

        if (!files[i].includes('Lp'))
            continue


        arr.push(make(files[i]))
    }
    await Promise.all(arr)
    await sleep(50)
    return checker()
}

async function make(name) {
    let stats = await fs.statSync(path + name)
    let size = getSizeFromName(name)

    if (size !== stats.size) {
        // console.log(name + ' changes')
        updateSizeFromName(name, stats.size)
        await updateVars(name)
    }


}


async function updateVars(name) {
    let lastFile = await fs.readFileSync(path + name, 'utf8')
    lastFile = lastFile.split('\n')
    let lastData = lastFile[lastFile.length - 2]

    let sig = ''
    let allData = getAllFromName(name)
    if (lastData.includes('Buy'))
        sig = allData.id + '_Buy'
    else
        sig = allData.id + '_Sell'


    let data = grabData([lastData])
    closer(sig, data[0].closeTime, data[0], allData.id, allData.pair)

    let vars = ai.run(data, allData.avgRunup, allData.avgDrawdown, getVarsFromName(name))

    let varUsage = getVarFromUsage(vars, allData.usage)
    console.log(allData.id, allData.usage, allData.value, varUsage)
    if (varUsage < allData.value) {
        //  console.log(allData.id +' '+'Try Add usage:'+allData.usage +' with current var '+varUsage +' and less than '+allData.value)
        if (lastData.includes('Buy'))
            sig = allData.id + '_Sell'
        else
            sig = allData.id + '_Buy'
        adder(sig, allData.qty, data[0].closeTime, data[0], allData.pair)
    }
    // console.log(name,vars)
    updateVarsFromName(name, vars)

}

function getVarFromUsage(vars, usage) {


    if (usage === 'fft') {
        return vars.countDrop
    } else if (usage === 'ddPlusRunCount') {
        return vars.drawDownPlusRunUpCount
    } else if (usage === 'ProfitZeroProfit') {
        return vars.allLossProfit
    } else if (usage === 'RunupDrawDownZeroRunupDrawDown') {
        return vars.drawDownPlusRunUpPercent
    } else if (usage === 'ProfitZeroDrawDown') {
        return vars.ProfitZeroDrawDownPercent
    } else if (usage === 'fftRunup') {
        return vars.countDropRunup
    } else if (usage === 'ProfitZeroDrawDownProfit') {
        return vars.diffDrawdownProfitAll
    } else if (usage === 'ProfitZeroProfitRunup') {
        return vars.canCreateRunupPercent
    } else if (usage === 'ProfitZeroRunupProfit') {
        return vars.VarProfitZeroRunupProfit
    } else if (usage === 'ProfitZeroRunupDrawDown') {
        return vars.VarProfitZeroRunupDrawDown
    } else if (usage === 'RunUpDrawDownZeroProfit') {
        return vars.RunUpDrawDownAllLossProfit
    } else if (usage === 'RunUpDrawDownZeroDrawDownProfit') {
        return vars.RunupDrawDownDiffDrawdownProfitAll
    } else if (usage === 'RunUpDrawDownZeroDrawdown') {
        return vars.runUpDrawDownZeroDrawDownPercent
    } else if (usage === 'RunUpDrawDownZeroRunupProfit') {
        return vars.VarDrawDownZeroProfit
    } else if (usage === 'RunupZeroRunupDrawDown') {
        return vars.VarRunupZeroRunupDrawDown
    } else if (usage === 'RunupZeroProfit') {
        return vars.VarRunupZeroProfit
    } else if (usage === 'RunupZeroProfitDrawDown') {
        return vars.VarRunupZeroProfitDrawDown
    } else if (usage === 'RunupZeroDrawDown') {
        return vars.VarRunupZeroDrawDown
    } else if (usage === 'RunupZeroProfitRunup') {
        return vars.VarRunupZeroProfitRunup
    } else if (usage === 'DrawDownZeroDrawDown') {
        return vars.VarDrawDownZeroDrawDown
    } else if (usage === 'DrawDownnZeroProfit') {
        return vars.VarDrawDownnZeroProfit
    } else if (usage === 'DrawDownZeroProfitDrawDown') {
        return vars.VarDrawDownZeroProfitDrawDown
    } else if (usage === 'DrawDownZeroProfitRunup') {
        return vars.VarDrawDownZeroProfitRunup
    } else if (usage === 'DrawDownZeroRunupDrawDown') {
        return vars.VarDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitDrawDownZeroDrawDown') {
        return vars.VarProfitDrawDownZeroDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfit') {
        return vars.VarProfitDrawDownZeroProfit
    } else if (usage === 'ProfitDrawDownZeroProfitDrawDown') {
        return vars.VarProfitDrawDownZeroProfitDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfitRunup') {
        return vars.VarProfitDrawDownZeroProfitRunup
    } else if (usage === 'ProfitDrawDownZeroRunupDrawDown') {
        return vars.VarProfitDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitRunupZeroDrawDown') {
        return vars.VarProfitRunupZeroDrawDown
    } else if (usage === 'ProfitRunupZeroProfit') {
        return vars.VarProfitRunupZeroProfit
    } else if (usage === 'ProfitRunupZeroProfitDrawDown') {
        return vars.VarProfitRunupZeroProfitDrawDown
    } else if (usage === 'ProfitRunupZeroProfitRunup') {
        return vars.VarProfitRunupZeroProfitRunup
    } else if (usage === 'ProfitRunupZeroRunupDrawDown') {
        return vars.VarProfitRunupZeroRunupDrawDown
    }


}


async function closer(sig, date, bigData, id, pair) {
    let lastToken = sig + '_2' + date
    lastToken = lastToken.replace(/_/g, '').replace(/Lp/g, '').replace(/BTC/g, '').replace(/ /g, '')
    const [data, delStatus] = await client
        .multi()
        .get(info.apiKey+'_'+sig)
        .del(info.apiKey+'_'+sig)

        .exec();


    if (delStatus !== 1) {

        return
    }


    let d
    let newData = JSON.parse(data)
    let qty = newData.qty
    console.log('try reduce', sig, qty)
    if (sig.includes('Buy')) {
        try {
            d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {
                reduceOnly: true,
                order_link_id: lastToken
            })
        } catch (e) {
            try {
                d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {
                    reduceOnly: true,
                    order_link_id: lastToken
                })
            } catch (e) {
                console.log('Error ->', sig, qty, 'Sell', 'Reduce true')
            }
        }
    } else {
        try {
            d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {reduceOnly: true, order_link_id: lastToken})
        } catch (e) {
            try {
                d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {
                    reduceOnly: true,
                    order_link_id: lastToken
                })
            } catch (e) {
                console.log('Error ->', sig, qty, 'Buy')
            }
        }
    }
    // await sleep(60000)
    // d = await exchange.fetchOrder(d.id, d.info.symbol)
    // let profit = getCalculateProfit(newData.price, d.average)
    // if (newData.side === 'sell')
    //     profit = profit * -1
    //
    // let det = 'side:' + newData.side + ' bybit open price:' + newData.price + ' bybit close price:' + d.average
    //
    // let t = id + '  :' + det + ' bybit profit:' + ' ' + profit + ' yashil profit:' + bigData.profit + ' diff:' + (profit - bigData.profit)
    // appendDiffProfitLog(t)


}


async function adder(sig, qty, date, allData,pair) {
    let lastToken = sig + '_' + date
    if (pair === 'BNBUSDT')
        qty = 0.06
    else if (pair === 'BTCUSDT')
        qty = 0.001
    else if (pair === 'ETHUSDT')
        qty = 0.01
    lastToken = lastToken.replace(/_/g, '').replace(/Lp/g, '').replace(/BTC/g, '').replace(/ETH/g, '').replace(/eth/g, '').replace(/BNB/g, '').replace(/bnb/g, '').replace(/ /g, '')
    console.log('Add db and ex :', lastToken)
    let d
    // console.log(pair,qty)
    if (sig.includes('Buy')) {

        d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {order_link_id: lastToken})
        //  console.log('Add Suc With id',sig)

    } else {
        d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {order_link_id: lastToken})
        //  console.log('Add Suc With id',sig)

    }

    if (typeof d.id !== "undefined") {
        console.log('Add Suc With id', d.id, sig)
        const [add] = await client
            .multi()
            .set(info.apiKey+'_'+sig, JSON.stringify({pair: d.info.symbol, side: d.side, qty: d.amount, price: d.price}))
            .exec();

    }

// console.log(d)
//     if (typeof d.id !== "undefined") {
//         await sleep(60000)
//         try {
//             d = await exchange.fetchOrder(d.id, d.info.symbol)
//             console.log('Add Suc With id', d.id, sig)
//             const [add] = await client
//                 .multi()
//                 .set(sig, JSON.stringify({pair: d.info.symbol, side: d.side, qty: d.amount, price: d.average}))
//                 .exec();
//         }
//         catch (e)
//         {
//
//             console.log('Add Suc With id', d.id, sig)
//             console.log(sig,'Have Problem Reding Order so try offline')
//             const [add] = await client
//                 .multi()
//                 .set(sig, JSON.stringify({pair: d.info.symbol, side: d.side, qty: d.amount, price: d.price}))
//                 .exec();
//         }
//
//     }


}


function getVarsFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].vars
}

function getSizeFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].size
}

function getAllFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i]
}


function updateVarsFromName(name, vars) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].vars = vars
}

function updateSizeFromName(name, size) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            datas[i].size = size
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}

function getCalculateProfit(basePrice, value) {
    return ((value - basePrice) / basePrice) * 100
}


function appendDiffProfitLog(log) {
    fs.appendFile('C:\\Users\\Administrator\\.pm2\\logs\\change-profit-diff.txt', log + '\n', function (err) {
        if (err) throw err;

    });
}

function appendBalanceProfitLog(log) {
    fs.appendFile('C:\\Users\\Administrator\\.pm2\\logs\\change-balance.txt', log + '\n', function (err) {
        if (err) throw err;

    });
}


