let fs = require('fs')
let _ = require('lodash')
let moment = require('moment-timezone')
let maxLevel=15
run()

async function run() {

    let configs = await fs.readdirSync('uniq/')
    let types = []

    for (let i = 0; i < configs.length; i++) {


        let config = await fs.readFileSync('./uniq/' + configs[i] + '/default/compound1000.json', 'utf8')
        config = JSON.parse(config)


        for (let j = 0; j < config.length; j++) {
            if (config[j].maxLevel >= maxLevel)
                types.push(config[j].type.split('targetPercentage:false')[1])
        }


    }

    let uniqType = _.uniq(types);
    createConfileADV(JSON.stringify(uniqType, null, 2))


}

function getDaysDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed, 'YYYY-MM-DD').format());
    var end = moment.duration(now.diff(moment(start, 'YYYY-MM-DD')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function createfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('date.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createConfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('con2.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}