let fs = require('fs')
let _ = require('lodash')
var shell = require('shelljs');
let prefix = 'work'
let cores = 15


//init()


copyAllFiles()

async function init() {
    try {
        await fs.mkdirSync('detail')
    } catch (e) {

    }
    try {
        await fs.mkdirSync('detailsJson')
    } catch (e) {

    }


    for (let i = 0; i < cores; i++) {
        let res = await fs.existsSync('work/'+prefix + i)
        if (!res) {
            await fs.mkdirSync('work/'+prefix + i)

        }
        await makeStatus('work'+prefix + i)
    }


    check()


}

function makeStatus(directory) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/work' + '.txt', '0', 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function check() {
    let files = await fs.readdirSync('allFiles')
    if (files.length === 0)
        process.exit(0)
    let size = await fs.read
    for (let i = 0; i < files.length; i++) {


        if (!files[i].includes('csv')) {
            await fs.unlinkSync('allFiles/' + files[i])
            continue
        }

        let stats = await fs.statSync('allFiles/' + files[i])
        if (stats.size < 1000) {

            await fs.unlinkSync('allFiles/' + files[i])
            continue
        }
        //  console.log(stats.size)


        let worker = await findOffWorker()
        //  console.log(worker)
        let configFileName = files[i].split('-')[0]

        if (worker !== null) {
            await fs.renameSync('allFiles/' + files[i], worker + '/' + files[i])
            await makeStatusNew(worker, '1')
            //console.log('node run.js ' + worker +' '+configFileName)
          //  console.log('node run.js ' + worker + ' ' + configFileName +' '+JSON.stringify(checks))
            shell.exec('node run.js ' + worker + ' ' + configFileName , {async: true});
        }


    }

    await sleep(250)
    return check()


    //  console.log(files)
}


function writeFileDetail( data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile( 'detail.json', JSON.stringify(data), 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function copyAllFiles() {
    try {
        await fs.mkdirSync('detail')
    } catch (e) {

    }
    try {
        await fs.mkdirSync('detailsJson')
    } catch (e) {

    }

    let configs = await fs.readdirSync('detailsJson')
  //  console.log(configs)
    let arr = []
    for (let z = 0; z < configs.length; z++) {

        if (!configs[z].includes('json')) {
            await fs.unlinkSync('detailsJson/' + configs[z])
            continue
        }
        let res = await fs.readFileSync('./detailsJson/' + configs[z], 'utf8');
        res = JSON.parse(res)

        let obj={}
        for (let i = 0; i < res.length; i++) {
          //  console.log(res[i].platform.split('-'))
            obj.configFile = res[i].platform.split('-')[0]
            obj.csvFile = res[i].platform.split('-')[1]
            obj.check = res[i].platform + '&' + res[i].type
            arr.push(obj.check)
            await fs.copyFileSync('files/' + obj.csvFile, 'allFiles' + '/' + obj.configFile + '-' + obj.csvFile)

        }



        // let files = await fs.readdirSync('files')
        // let size = await fs.read
        // for (let i = 0; i < files.length; i++) {
        //
        //
      //  console.log('files/' + obj.csvFile)

        //
        //
        // }
    }
await writeFileDetail(arr)
     init()
}

function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


function makeStatusNew(directory, status) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('work/'+directory + '/work' + '.txt', status, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function findOffWorker() {
    let arr = []
    for (let i = 0; i < cores; i++) {
        let res = await fs.readFileSync('./work/' + prefix + i + '/work.txt', 'utf8');
        if (res.includes('0'))
            arr.push(prefix + i)

    }
    arr = _.shuffle(arr)
    if (arr.length !== 0)
        return arr[0]

    else return null

}