let moment = require('moment-timezone')
const fs = require('fs');
let _=require('lodash')

let plus = 'plus'
let zarib = 'zarib'
let base = 'base'
let dynamic = 'dynamic'
let elsa = 'elsa'


function run(data, config, risk, pfTrade, riskFreeLevel, detail, loss, durs, maxTradeDays) {
    let type = config.type + ' param:' + config.param + ' base:' + config.base + ' target:' + config.target
    let saveData = []
    let needPrintData = shouldPrint(detail, data[0].signal + '&' + type)
    // console.log(needPrintData)

    let commision = config.commision
    let money = config.base
    let total = 0
    let maxDays = 0
    let startDays = 0
    let allTotal = 0
    let listDays = []
    let maxReserve = 0
    let maxMeta = 0
    let allLoss = 0
    let curDrawDown = 0
    let maxAllocatedMoney = 0
    let maxLevel = 0
    //  console.log(data)


    let step = 0
    let reserv = 0
    let meta = 0
    let profit = 0
    let lastCom = 0
    let lastMoney = 0
    let levels = []
    let detailLevel = []
    let durDetail=[]

    let dur
    try {
        dur = getNewMinDiff(data[0].openDate, data[data.length - 1].closeDate)
    } catch (e) {
        return null

    }

    if (dur < durs)
        return null

    let newP = dur / data.length
    //  console.log(data.length)
    //  console.log(newP)
    if (pfTrade < newP)
        return null
    for (let i = 0; i < data.length; i++) {

        if (maxDays > maxTradeDays)
            return null
        let obj
        if (step === 0) {
            startDays = data[i].openDate
            money = config.base
        } else {
            if (config.type === zarib)
                money = lastMoney * config.param
            if (config.type === base)
                money = config.base * config.param * step
            else if (config.type === plus)
                money = config.base * (step + 1)
            else if (config.type === dynamic) {
                if (curDrawDown <= 0)
                    money = lastMoney
                else {
                    money = percentage2(lastMoney, config.param * curDrawDown)
                }
            } else if (config.type === elsa) {
                if (curDrawDown <= 0)
                    money = lastMoney
                else {
                    let b = curDrawDown / 10

                    b = b + Math.abs(config.param)


                    money = lastMoney * (b)

                }
            }
        }
        let riskfree = false
        if (step > riskFreeLevel)
            riskfree = true
        let d = inlineCheck(money, commision, data[i], profit, lastCom, config.target, riskfree)


        if (d.reserve < 0 && Math.abs(d.reserve) > Math.abs(maxReserve))
            maxReserve = d.reserve


        if (d.meta < 0 && Math.abs(d.meta) > Math.abs(maxMeta))
            maxMeta = d.meta

        //  console.log(maxAllocatedMoney)
        if (money > maxAllocatedMoney)
            maxAllocatedMoney = money

        //      console.log(data[i])
        //   console.log( 'step->'+step)
        //   console.log(d)


        if (step > maxLevel)
            maxLevel = step

        if (needPrintData) {

            obj = d
            obj.signal = data[i]

            if (d.meta < 0)
                obj.currentDrawDown = Math.abs(((d.meta * 100) / money))
            else
                obj.currentDrawDown = 0

            obj.maxReserve = maxReserve
            obj.maxAllocatedMoney = maxAllocatedMoney
            obj.maxLevel = maxLevel
            obj.step = step
            obj.maxDays = maxDays


        }

        if (loss !== 0 && d.meta < 0 && Math.abs(d.meta) > loss) {
            allLoss = allLoss + d.meta
            levels.push(step)
            step = 0
            reserv = 0
            profit = 0
            lastCom = 0
            lastMoney = 0
            allTotal++
            // if (!d.riskFree)
            //     total++
            if (needPrintData)
                saveData.push(obj)
            continue

        }
        if (d.done === true) {
            let endDays = getNewMinDiff(startDays, data[i].closeDate)
            detailLevel.push({step: step, dur: endDays})
            durDetail.push({dur:endDays.toFixed(2),step:step,days:startDays.split(' ')[0]+'-'+data[i].closeDate.split(' ')[0]})
            //  console.log(typeof  endDays)
            //console.log(endDays)
            if (endDays > maxDays)
                maxDays = endDays

            listDays.push(endDays)

            //   console.log(maxDays)
            levels.push(step)
            step = 0
            reserv = 0
            profit = 0
            lastCom = 0
            curDrawDown = 0
            lastMoney = 0
            allTotal++
            if (!d.riskFree)
                total++

        } else {

            step++
            profit = profit + d.profit
            lastMoney = d.lastMoney
            lastCom = lastCom + d.com

            if (d.meta < 0)
                curDrawDown = Math.abs(((d.meta * 100) / money))
            else
                curDrawDown = 0
            if (needPrintData) {

                obj.profitAll = profit
                obj.lastMoney = lastMoney


            }

        }

        if (needPrintData)
            saveData.push(obj)
    }
    let s = 0
    for (let i = 0; i < listDays.length; i++) {
        s = s + listDays[i]
    }
    s = s / (listDays.length)


    let newReserv = maxReserve
    maxReserve = maxMeta
    let firstMaxAllocatedMoney = maxAllocatedMoney
    if (config.param !== 0) {
        for (let i = 0; i < risk; i++)
            maxAllocatedMoney = maxAllocatedMoney * config.param
    }

    if (needPrintData) {
        for (let i = 0; i < saveData.length; i++) {
            try {
                if (saveData[i].meta < 0)
                    saveData[i].perMeta = Math.abs(((saveData[i].meta * 100) / maxAllocatedMoney))
                else
                    saveData[i].perMeta = 0

                if (saveData[i].reserve < 0)
                    saveData[i].perReserve = Math.abs(((saveData[i].reserve * 100) / maxAllocatedMoney))
                else
                    saveData[i].perReserve = 0

            } catch (e) {

            }
        }
    }

    let newLevel = []
    let newLevelText = ''
    for (let i = 0; i < (maxLevel + 1); i++) {
        let count = counter(i, levels)
        let avgDur=getAvgDur(i,detailLevel)
        //   newLevel.push({level:i,count:count})
        let per = parseFloat((count / allTotal) * 100).toFixed(1)


        newLevelText = newLevelText + i + ':' + count + ':' + per + '%' + ':'+avgDur+'///'
        if ((i + 2) % 12 === 0) {

            newLevelText + newLevelText + '\\n'

        }


    }

    durDetail = _.orderBy(durDetail, ['dur'], ['desc']);
    let durDetailText=''
    for (let i=0;i<durDetail.length;i++)
    {
        if (i>10)
            break
        durDetailText=durDetailText+durDetail[i].step+':'+durDetail[i].dur+':'+durDetail[i].days+'///'
    }
    // console.log(newLevelText)

    //  for (let i=0;i<newLevel)


    let totalFinal = total * config.target
    let totalPlus = totalFinal + allLoss
    let oldTotalFinal = totalFinal
    totalFinal = totalPlus
    let newT = totalFinal / dur
    let percentage = maxReserve + totalFinal
    percentage = maxAllocatedMoney / percentage
    let minus = 0
    if (percentage < 0) {
        minus = percentage
        percentage = null
    }

    let profitPerMonth = (newT * 30 * 100) / maxAllocatedMoney


    // let  percentage2 = maxReserve + newT
    //  percentage2 = maxAllocatedMoney / percentage2
    //  let minus2 = 0
    //  if (percentage2 < 0) {
    //       minus2 = percentage2
    //      percentage2 = null
    //  }

    let perp = (config.target * 100) / Math.abs(maxAllocatedMoney)
    perp = perp / 100

    let sum = Math.abs(maxAllocatedMoney)

    for (let i = 0; i < total; i++)
        sum = sum + (sum * perp)
    sum = sum - Math.abs(maxAllocatedMoney)
    let newCompund = sum / dur

    let compoundPerMonth = (newCompund * 30 * 100) / Math.abs(maxAllocatedMoney)

    let drawDown = Math.abs(((maxReserve * 100) / maxAllocatedMoney))
    let opt = {
        platform: data[0].signal,
        type: type,
        total: total,
        allTotal: allTotal,
        avgLevel: maxLevel / total,
        maxLevel: maxLevel,
        dur: dur,
        maxDays: maxDays,
        avgDays: s,
        allLoss: allLoss,
        totalFinal: oldTotalFinal,
        totalPlus: totalPlus,
        totalCompound: sum,
        profitPerMonth: Math.abs(profitPerMonth),
        compoundPerMonth: compoundPerMonth,

        firstMaxAllocatedMoney: firstMaxAllocatedMoney,
        maxAllocatedMoney: maxAllocatedMoney,

        avgAllocatedMoney: maxAllocatedMoney / total,
        drawDown: drawDown,
        CompoundPerMonthDrawDown: compoundPerMonth / drawDown,
        profitPerMonthDrawDown: Math.abs(profitPerMonth) / drawDown,
        maxReseve: newReserv,
        maxMeta: maxMeta,
        avgReserve: maxReserve / total,
        percentage: percentage,
        avgProfitPerDay: newT,
        allocatedReserve: (maxAllocatedMoney) / Math.abs(maxReserve),
        durDetailText:durDetailText,
        minus: minus,
        risk: risk,
        levels: newLevelText,
        pftrade: newP,

        countOfTrade: data.length


    }

    if (needPrintData) {
        fs.writeFile('detail/' + opt.platform + '-' + 'param' + config.param + 'base' + config.base + 'target' + config.target + '.json', JSON.stringify(saveData, null, 2), 'utf8', function (err) {

        });
    }


    return opt


    // console.log(data)
}


function counter(count, array) {
    let sum = 0
    for (let i = 0; i < array.length; i++)
        if (array[i] === count)
            sum++

    return sum

}

function getAvgDur(step, detailLevel) {
    let allDur = 0
    let count = 0
    for (let i = 0; i < detailLevel.length; i++)
        if (detailLevel[i].step === step) {
            count++
            allDur = allDur + detailLevel[i].dur
        }

    try {
        return parseFloat(allDur / count).toFixed(3)
    } catch (e) {
        return 0
    }

}

function percentage2(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return base + temp
}


function inlineCheck(money, com, data, profit, lastCom, tar, riskFree) {
    //  console.log(profit)

    com = com * money
    let minProf = profit * -1
    let target = money + minProf + com + lastCom

    let targetDetail = '(' + money + ')' + '+' + '(' + minProf + ')+(' + com + ')+(' + lastCom + ')'
    if (!riskFree) {
        target = target + tar
        targetDetail = targetDetail + '+(' + tar + ')'
    }


    let reserve = percentage(money, data.drawDown)

    let profitMoney = percentageMinus(money, data.profit)

    let diff = reserve - money
    diff = diff - com - lastCom + profit

    let meta = profitMoney + profit - com - lastCom

    //  console.log('reserve->'+reserve + ' money->'+money +' com->'+com +' lastCom->'+lastCom + 'profit->'+profit  +' diff->'+diff)


    if (percentage(money, data.runUp) > target)
        return {
            done: true,
            money: money,
            meta: meta,
            reserve: diff,
            riskFree,
            profitLastSteps: profit,
            profit: profitMoney,
            lastCom: lastCom,
            com: com,
            target: target,
            targetDetail: targetDetail
        }
    else
        return {
            done: false,
            money: money,
            meta: meta,
            reserve: diff,
            profitLastSteps: profit,
            profit: profitMoney,
            lastMoney: money,
            com: com,
            target: target,
            targetDetail: targetDetail
        }


}


function calPer(entry, last) {
    return ((last - entry) / entry) * 100
}

function shouldPrint(details, type) {
    for (let i = 0; i < details.length; i++) {
        if (details[i] === type)
            return true
    }

    return false
}

function percentage(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return base + temp
}

function percentageMinus(base, per) {

    base = parseFloat(base)
    per = parseFloat(per)
    let percentager = per / 100
    let temp = base * percentager
    return temp
}

function getMinDiff(start, closed) {
    //2019-05-25T05:34:27+04:30
    var now = moment(moment(closed).tz('Asia/Tehran').format());
    var end = moment.duration(now.diff(moment(start).tz('Asia/Tehran')));
    // console.log(parseInt(end.asDays()))
    return parseInt(end.asDays())


}

function getNewMinDiff(s, c) {


    const diffInMs = new Date(c) - new Date(s)
    return diffInMs / (1000 * 60 * 60 * 24);


}


module.exports =
    {

        run: run,


    }