let fs = require('fs')
let _ = require('lodash')
var shell = require('shelljs');
let reverse=require('./reverse')
let prefix = 'work'
let cores = 50


//init()


copyAllFiles()

async function init() {
    try {
        await fs.mkdirSync('detail')
    }
    catch (e)
    {

    }


    try {
        await fs.mkdirSync('work')
    }
    catch (e)
    {

    }
    try {
        await fs.mkdirSync('detailsJson')
    }
    catch (e)
    {

    }

    try {
        await fs.mkdirSync('result')
    }
    catch (e)
    {

    }





    for (let i = 0; i < cores; i++) {
        let res = await fs.existsSync('work/'+prefix + i)
        if (!res) {
            await fs.mkdirSync('work/'+prefix + i)

        }
        await makeStatus('work/'+prefix + i)
    }


    check()


}

function makeStatus(directory) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/work' + '.txt', '0', 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function check() {
    try {
        await fs.mkdirSync('allFiles')
    }
    catch (e)
    {

    }
    let files = await fs.readdirSync('allFiles')
    if (files.length ===0)
        process.exit(0)
    let size = await fs.read
    for (let i = 0; i < files.length; i++) {


        if (!files[i].includes('csv')) {
            await fs.unlinkSync('allFiles/' + files[i])
            continue
        }

        let stats = await fs.statSync('allFiles/' + files[i])
        // if (stats.size < 5000) {
        //
        //   //  await fs.unlinkSync('allFiles/' + files[i])
        //     continue
        // }
        //  console.log(stats.size)


        let worker = await findOffWorker()
        //  console.log(worker)
        let configFileName=files[i].split('-')[0]

        if (worker !== null) {
            await fs.renameSync('allFiles/' + files[i], 'work/'+worker + '/' + files[i])
            await makeStatusNew(worker, '1')
            //console.log('node run.js ' + worker +' '+configFileName)
            shell.exec('node run.js ' + worker +' '+configFileName +' '+JSON.stringify([]), {async: true});
        }


    }

    await sleep(250)
    return check()


    //  console.log(files)
}


async function copyAllFiles()
{
    //  await reverse.init()
    //  await sleep(2000)
    let configs = await fs.readdirSync('configs')
    for (let z=0;z<configs.length;z++)
    {
        try {
            await fs.mkdirSync('result/' + configs[z])
        }
        catch (e)
        {

        }

        let dirFiles=await fs.readdirSync('files')
        for (let f=0;f<dirFiles.length;f++)
        {
            let files = await fs.readdirSync('files/'+dirFiles[f])
            //  console.log(files)
            let size = await fs.read
            for (let i = 0; i < files.length; i++) {

                if (!files[i].includes('csv')) {
                    await fs.unlinkSync('files/'+dirFiles[f]+'/' + files[i])
                    continue
                }

                let stats = await fs.statSync('files/'+dirFiles[f]+'/' + files[i])
                // if (stats.size < 1000) {
                //
                //  //   await fs.unlinkSync('files/'+dirFiles[f]+'/' + files[i])
                //     continue
                // }






                await fs.copyFileSync('files/'+dirFiles[f]+'/' + files[i], 'allFiles' + '/' + configs[z]+'-'+files[i])




            }
        }

    }
    await writeFileDetail([])
    init()
}

function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


function makeStatusNew(directory, status) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('work/'+directory + '/work' + '.txt', status, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}

function writeFileDetail( data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile( 'detail.json', JSON.stringify(data), 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function findOffWorker() {
    let arr = []
    for (let i = 0; i < cores; i++) {
        let res = await fs.readFileSync('./work/' + prefix + i + '/work.txt', 'utf8');
        if (res.includes('0'))
            arr.push(prefix + i)

    }
    arr = _.shuffle(arr)
    if (arr.length !== 0)
        return arr[0]

    else return null

}