let fs = require('fs')
var watch = require('node-watch');
let ai = require('./ai-new')
let path = 'E:\\YashilFinal\\'
let longSide = 'LONG'
let shortSide = 'SHORT'
let bybit = require('./test_bybit')
let zignaly = require('./zignaly')
let redis = require('redis')
const client = redis.createClient(
    {url: 'redis://default:p@db.zignaly.xyz:7001'}
);
let datas = []
let balance = 0


const ccxt = require('ccxt')


let exchange
let info
var cors = require('cors')
const _ = require('lodash')
let express = require('express');
let moment = require('moment-timezone')

let app = express();
let files=[]
var bodyParser = require('body-parser')


let server = require('http').createServer(app);


let port = 80;
init()

app.use(cors())
app.use(bodyParser.text());
server.listen(port, () => {
    console.log('Server listening at port %d', port);


})


app.post('/signal', (req, res) => {

    res.send('Done')

    console.log(req.body)
   analyse(req.body)


})
app.post('/', (req, res) => {

    res.send('Done')

    console.log(req.body)
     analyse(req.body)


})

async function analyse(body) {
    let t = body.split(',')
    let obj = {}
    if (typeof  t[0] ==="undefined")
        return
    obj.symbol = t[0]
    obj.entry = parseFloat(t[1])
    obj.exit = parseFloat(t[2])
    obj.side = t[3]
    obj.timeframe = t[4]
    obj.runUp = parseFloat(t[5])
    obj.drawDown = parseFloat(t[6])
    obj.profit = getPercent(obj.entry, obj.exit)
    if (obj.side ==='Short' )
        obj.profit=obj.profit*-1
    obj.runUp = getPercent(obj.entry, (obj.runUp + obj.entry))
    obj.drawDown = getPercent(obj.entry, (obj.drawDown + obj.entry))
    obj.closeTime = moment().utc().format('YYYY.MM.DD HH:mm') + ':00.000'
    let indicator = ''
    for (let i = 7; i < t.length; i++) {
        indicator = indicator + t[i]
        if (i !== t.length - 1)
            indicator = indicator + '&'
    }
//Ticket,Open_Time,Type,Symbol,Open_Price,Close_Price,Close_Time,dPrfPipWrtOpPrPc,dAgeHiPrfInPrPc_RunUpPc,dAgeLoPrfInPrPc_DrawDownPc

    let final = '0,00:00,'
    if (obj.side === 'Long') {
        final = final + 'Buy'
        obj.side = 'Buy'
    } else {
        final = final + 'Sell'
        obj.side = 'Sell'
    }
    final = final + ',BTCUSDT,'

    final = final + obj.entry + ',' + obj.exit + ',' + obj.closeTime + ',' + obj.profit + ',' + obj.runUp + ',' + obj.drawDown
    appendCsv(final, indicator)
    indicator = indicator.replace('Kelt', 'btc4').replace('SOTT', 'btc3').replace('Pmax', 'btc2').replace('PPST', 'btc1').replace('.csv', '')

    //appendCsvtoMain(final,indicator)
  //  updateVars(indicator,final)

}

function appendCsv(data, name) {
    fs.appendFile('temp/' + name + '.csv', data + '\n', function (err) {
        if (err) throw err;

    });
}

async function appendCsvtoMain(data, config) {




    for (let i = 0; i < files.length; i++) {

        if (files[i].startsWith(config + '_')) {
            appendtoFile(files[i],data)
        }
    }


}

function appendtoFile(name,data)
{
    fs.appendFile('E:\\YashilFinal\\'+name, data + '\n', function (err) {
        if (err) throw err;

    });
}

function getPercent(basePrice, value) {
    return ((value - basePrice) / basePrice) * 100
}





async function init() {
    files = await fs.readdirSync('E:\\YashilFinal')
    client.on('error', (err) => console.log('Redis Client Error', err));

    await client.connect();
    info = await fs.readFileSync('info2.json', 'utf8');
    info = JSON.parse(info)
    exchange = new ccxt.bybit({
        apiKey: info.apiKey,
        secret: info.secret,
        enableRateLimit: true,

    })

   //  exchange.urls['api'] = exchange.urls['test'];

    run()
  //   balanceUpdater()
}


async function balanceUpdater() {
    try {
        let d = await exchange.fetchBalance()
        if (d.info.result.USDT.equity !== balance) {
            balance = d.info.result.USDT.equity
            appendBalanceProfitLog(balance)
        }

    } catch (e) {
console.log(e)
    }
    await sleep(60000)
    return balanceUpdater()
}


async function run() {
    let files = await fs.readdirSync(path)
    for (let i = 0; i < files.length; i++) {
        // if (files[i] !=='btc1&1&1&1_btcLp1819RZDD75_0.1_-0.1_RunupZeroDrawDown_0.01.csv')
        //     continue

        let fl = files[i].split('_')
        let pair = 'BTCUSDT'
        // console.log(pair)
        let avgRunup = parseFloat(fl[2])
        let avgDrawDown = parseFloat(fl[3])
        let lastFile = await fs.readFileSync(path + files[i], 'utf8')
        let stats = await fs.statSync(path + files[i])
        lastFile = lastFile.split('\n')
        // console.log(lastFile[lastFile.length - 2])

        let data = grabData(lastFile)


        let vars = ai.run(data, avgRunup, avgDrawDown)
        let sp = files[i].split('_')
        let id = sp[0]
        let usage = sp[4]
        let value = parseFloat(sp[5])
        let qty = 0.002
//console.log(vars.VarProfitDrawDownZeroProfit)
        datas.push({
            name: files[i],
            size: stats.size,
            pair: pair,
            vars: vars,
            id: id,
            usage: usage,
            value: (-1 * value),
            avgRunup: avgRunup,
            avgDrawDown: avgDrawDown,
            qty: qty
        })
    }


 //   checker()
   // console.log(datas)

}


function grabData(data) {
    // console.log(data)
    let arr = []
    for (let i = 0; i < data.length; i++) {


        try {
            let d = data[i].split(',')
            let profit = parseFloat(d[7])
            let runUp = parseFloat(d[8])
            let drawDown = parseFloat(d[9])
            let t = d[6]
            t = t.split(':')
            let closeTime = t[0] + ':' + t[1]

            if (isNaN(profit))
                continue
            arr.push({profit, runUp, drawDown, closeTime})
        } catch (e) {

        }

    }

    return arr
}







async function updateVars(name, lastData) {

    //  lastData = lastFile[lastFile.length - 2]

    let sig = ''
    let allData = getAllFromName(name)
    if (lastData.includes('Buy'))
        sig = allData.id + '_Buy'
    else
        sig = allData.id + '_Sell'


    let data = grabData([lastData])
    closer(sig, data[0].closeTime, data[0], allData.id, allData.pair)

    let vars = ai.run(data, allData.avgRunup, allData.avgDrawdown, getVarsFromName(name))

    let varUsage = getVarFromUsage(vars, allData.usage)
    console.log(allData.id, allData.usage, allData.value, varUsage)
    if (varUsage < allData.value) {
        //  console.log(allData.id +' '+'Try Add usage:'+allData.usage +' with current var '+varUsage +' and less than '+allData.value)
        if (lastData.includes('Buy'))
            sig = allData.id + '_Sell'
        else
            sig = allData.id + '_Buy'
        adder(sig, allData.qty, data[0].closeTime, data[0], allData.pair)
       // console.log('adder')
    }
    // console.log(name,vars)
    updateVarsFromName(name, vars)

}

function getVarFromUsage(vars, usage) {


    if (usage === 'fft') {
        return vars.countDrop
    } else if (usage === 'ddPlusRunCount') {
        return vars.drawDownPlusRunUpCount
    } else if (usage === 'ProfitZeroProfit') {
        return vars.allLossProfit
    } else if (usage === 'RunupDrawDownZeroRunupDrawDown') {
        return vars.drawDownPlusRunUpPercent
    } else if (usage === 'ProfitZeroDrawDown') {
        return vars.ProfitZeroDrawDownPercent
    } else if (usage === 'fftRunup') {
        return vars.countDropRunup
    } else if (usage === 'ProfitZeroDrawDownProfit') {
        return vars.diffDrawdownProfitAll
    } else if (usage === 'ProfitZeroProfitRunup') {
        return vars.canCreateRunupPercent
    } else if (usage === 'ProfitZeroRunupProfit') {
        return vars.VarProfitZeroRunupProfit
    } else if (usage === 'ProfitZeroRunupDrawDown') {
        return vars.VarProfitZeroRunupDrawDown
    } else if (usage === 'RunUpDrawDownZeroProfit') {
        return vars.RunUpDrawDownAllLossProfit
    } else if (usage === 'RunUpDrawDownZeroDrawDownProfit') {
        return vars.RunupDrawDownDiffDrawdownProfitAll
    } else if (usage === 'RunUpDrawDownZeroDrawdown') {
        return vars.runUpDrawDownZeroDrawDownPercent
    } else if (usage === 'RunUpDrawDownZeroRunupProfit') {
        return vars.VarDrawDownZeroProfit
    } else if (usage === 'RunupZeroRunupDrawDown') {
        return vars.VarRunupZeroRunupDrawDown
    } else if (usage === 'RunupZeroProfit') {
        return vars.VarRunupZeroProfit
    } else if (usage === 'RunupZeroProfitDrawDown') {
        return vars.VarRunupZeroProfitDrawDown
    } else if (usage === 'RunupZeroDrawDown') {
        return vars.VarRunupZeroDrawDown
    } else if (usage === 'RunupZeroProfitRunup') {
        return vars.VarRunupZeroProfitRunup
    } else if (usage === 'DrawDownZeroDrawDown') {
        return vars.VarDrawDownZeroDrawDown
    } else if (usage === 'DrawDownnZeroProfit') {
        return vars.VarDrawDownnZeroProfit
    } else if (usage === 'DrawDownZeroProfitDrawDown') {
        return vars.VarDrawDownZeroProfitDrawDown
    } else if (usage === 'DrawDownZeroProfitRunup') {
        return vars.VarDrawDownZeroProfitRunup
    } else if (usage === 'DrawDownZeroRunupDrawDown') {
        return vars.VarDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitDrawDownZeroDrawDown') {
        return vars.VarProfitDrawDownZeroDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfit') {
        return vars.VarProfitDrawDownZeroProfit
    } else if (usage === 'ProfitDrawDownZeroProfitDrawDown') {
        return vars.VarProfitDrawDownZeroProfitDrawDown
    } else if (usage === 'ProfitDrawDownZeroProfitRunup') {
        return vars.VarProfitDrawDownZeroProfitRunup
    } else if (usage === 'ProfitDrawDownZeroRunupDrawDown') {
        return vars.VarProfitDrawDownZeroRunupDrawDown
    } else if (usage === 'ProfitRunupZeroDrawDown') {
        return vars.VarProfitRunupZeroDrawDown
    } else if (usage === 'ProfitRunupZeroProfit') {
        return vars.VarProfitRunupZeroProfit
    } else if (usage === 'ProfitRunupZeroProfitDrawDown') {
        return vars.VarProfitRunupZeroProfitDrawDown
    } else if (usage === 'ProfitRunupZeroProfitRunup') {
        return vars.VarProfitRunupZeroProfitRunup
    } else if (usage === 'ProfitRunupZeroRunupDrawDown') {
        return vars.VarProfitRunupZeroRunupDrawDown
    }


}


async function closer(sig, date, bigData, id, pair) {
    let lastToken = sig + '_2' + date
    lastToken = lastToken.replace(/_/g, '').replace(/Lp/g, '').replace(/BTC/g, '').replace(/ /g, '').replace(/btc2/g, '').replace(/btc3/g, '').replace(/btc4/g, '').replace(/&/g, '').replace(/btc/g, '').replace(/:/g, '')
    lastToken=removeDot(lastToken)
    const [data, delStatus] = await client
        .multi()
        .get(info.apiKey + '_' + sig)
        .del(info.apiKey + '_' + sig)

        .exec();


    if (delStatus !== 1) {

        return
    }


    let d
    let newData = JSON.parse(data)
    let qty = newData.qty
    console.log('try reduce', sig, qty)
    if (sig.includes('Buy')) {
        try {
            d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {
                reduceOnly: true,
                order_link_id: lastToken
            })
        } catch (e) {
            try {
                d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {
                    reduceOnly: true,
                    order_link_id: lastToken
                })
            } catch (e) {
                console.error(e)
                console.log('Error ->', sig, qty, 'Sell', 'Reduce true')
            }
        }
    } else {
        try {
            d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {reduceOnly: true, order_link_id: lastToken})
        } catch (e) {
            try {
                d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {
                    reduceOnly: true,
                    order_link_id: lastToken
                })
            } catch (e) {
                console.error(e)
                console.log('Error ->', sig, qty, 'Buy')
            }
        }
    }
    // await sleep(60000)
    // d = await exchange.fetchOrder(d.id, d.info.symbol)
    // let profit = getCalculateProfit(newData.price, d.average)
    // if (newData.side === 'sell')
    //     profit = profit * -1
    //
    // let det = 'side:' + newData.side + ' bybit open price:' + newData.price + ' bybit close price:' + d.average
    //
    // let t = id + '  :' + det + ' bybit profit:' + ' ' + profit + ' yashil profit:' + bigData.profit + ' diff:' + (profit - bigData.profit)
    // appendDiffProfitLog(t)


}



async function adder(sig, qty, date, allData, pair) {
    let lastToken = sig + '_' + date
    if (pair === 'BNBUSDT')
        qty = 0.06
    else if (pair === 'BTCUSDT')
        qty = 0.002
    else if (pair === 'ETHUSDT')
        qty = 0.01
    lastToken = lastToken.replace(/_/g, '').replace(/Lp/g, '').replace(/BTC/g, '').replace(/ /g, '').replace(/btc2/g, '').replace(/btc3/g, '').replace(/btc4/g, '').replace(/&/g, '').replace(/btc/g, '').replace(/:/g, '')
    lastToken=removeDot(lastToken)
    console.log('Add db and ex :', lastToken)
    let d
    // console.log(pair,qty)
    if (sig.includes('Buy')) {

        d = await exchange.createMarketOrder(pair, 'Buy', qty, 0, {order_link_id: lastToken})
        //  console.log('Add Suc With id',sig)

    } else {
        d = await exchange.createMarketOrder(pair, 'Sell', qty, 0, {order_link_id: lastToken})
        //  console.log('Add Suc With id',sig)

    }

    if (typeof d.id !== "undefined") {
        console.log('Add Suc With id', d.id, sig)
        const [add] = await client
            .multi()
            .set(info.apiKey + '_' + sig, JSON.stringify({
                pair: d.info.symbol,
                side: d.side,
                qty: d.amount,
                price: d.price
            }))
            .exec();

    }


}

function removeDot(text)
{
    let token=''
    for (let i=0;i<text.length;i++)
        if (text[i] !=='.' )
            token=token+text[i]

    return token
}
function getVarsFromName(config) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name.startsWith(config + '_'))
            return datas[i].vars
}

function getSizeFromName(name) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name === name)
            return datas[i].size
}

function getAllFromName(config) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name.startsWith(config + '_'))
            return datas[i]
}


function updateVarsFromName(config, vars) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name.startsWith(config + '_'))
            datas[i].vars = vars
}

function updateSizeFromName(config, size) {
    for (let i = 0; i < datas.length; i++)
        if (datas[i].name.startsWith(config + '_'))
            datas[i].size = size
}

async function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}

function getCalculateProfit(basePrice, value) {
    return ((value - basePrice) / basePrice) * 100
}


function appendDiffProfitLog(log) {
    fs.appendFile('C:\\Users\\Administrator\\.pm2\\logs\\change-profit-diff.txt', log + '\n', function (err) {
        if (err) throw err;

    });
}

function appendBalanceProfitLog(log) {
    fs.appendFile('C:\\Users\\Administrator\\.pm2\\logs\\change-balance.txt', log + '\n', function (err) {
        if (err) throw err;

    });
}


