const fs = require('fs')
let moment = require('moment-timezone')
const _ = require('lodash')
init()


async function init() {
    try {
        await fs.mkdirSync('analyse')

    } catch (e) {

    }
    let files = await fs.readdirSync('analyse')
    let prom = []
    for (let i = 0; i < files.length; i++) {
        if (files[i].includes('.csv')) {
            prom.push(format(files[i]))
        }

    }

    await Promise.all(prom)

}


async function format(name) {
    let res = await fs.readFileSync('./analyse/' + name, 'utf8');
    res = res.match(/.+/g)
    // console.log(res.length)


    let list = []
    let pluser = 0
    let allProfit = 0
    let con = 0
    let newCon = 0
    let newCounter = 0
    let diffCount = 0
    // console.log(res)
    let maxRed = 0
    let maxGreen=0
    let redCounter = 0
    let allGreeeCon=0
    let greenCounter=0
    let maxGreenArray=[]
    let maxRedArray=[]

    let maxTimeGreen=0
    let maxTimeRed=0
    for (let i = 1; i < (res.length - 1); i++) {
        try {
            let d = res[i].split(',')
            let open = parseFloat(d[1])
            let close = parseFloat(d[4])
            if (close < open) {
                if (greenCounter !==0)
                    maxGreenArray.push(greenCounter)
                if (greenCounter>maxGreen) {
                    maxTimeGreen=d[0]
                    maxGreen = greenCounter
                }
                greenCounter=0
                redCounter++
                con++
            } else {
                if (redCounter !==0)
                    maxRedArray.push(redCounter)
                if (redCounter > maxRed) {
                    maxTimeRed=d[0]
                    maxRed = redCounter
                }
                redCounter = 0
                greenCounter++
                allGreeeCon++
            }

        } catch (e) {

        }


    }

    let twoCounter=0
    // for (let i=0;i<maxRedArray.length;i++)
    //     if (maxRedArray[i] ===1)
    //         twoCounter++


    console.log('from ' + res.length + ' red ' + con, ' max red:'+maxRed ,'Max red Timestamp:'+maxTimeRed ,' green:'+allGreeeCon +' max green:'+maxGreen + ' max green time end:'+maxTimeGreen )
    // console.log('total '+con +'  avg runup:'+(allProfit/con))
    maxRedArray=_.orderBy(maxRedArray)
    maxRedArray=_.reverse(maxRedArray)
    // console.log('Max Red Candle Array:')
    // console.log(maxRedArray)
    maxGreenArray=_.orderBy(maxGreenArray)
    maxGreenArray=_.reverse(maxGreenArray)
    // console.log('Max Green Candle Array:')
    // console.log(maxGreenArray)

    let newxGreenArray=[]
    for (let i=0;i<maxGreenArray.length;i++)
    {
        let counter=0
        for (let j=0;j<maxGreenArray.length;j++)
            if (maxGreenArray[i] ===maxGreenArray[j])
                counter ++

        newxGreenArray.push({item:maxGreenArray[i],count:counter})
    }

    let newxRedArray=[]
    for (let i=0;i<maxRedArray.length;i++)
    {
        let counter=0
        for (let j=0;j<maxRedArray.length;j++)
            if (maxRedArray[i] ===maxRedArray[j])
                counter ++

        newxRedArray.push({item:maxRedArray[i],count:counter})
    }
newxGreenArray=_.uniqBy(newxGreenArray, 'item');
    newxRedArray=_.uniqBy(newxRedArray, 'item');
    console.log('Max Red Candle Array:')
    console.log(newxRedArray)
    console.log('Max Green Candle Array:')
    console.log(newxGreenArray)


}


function createFile(name, body) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('analyse/' + name, body, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}