const fs = require('fs')
let moment = require('moment-timezone')
init()


async function init() {
    try {
        await fs.mkdirSync('format')

    } catch (e) {

    }
    let files = await fs.readdirSync('format')
    let prom=[]
    for (let i = 0; i < files.length; i++) {
        if (files[i].includes('.csv')) {
            prom.push(format(files[i]))
        }

    }

    await Promise.all(prom)

}


async function format(name) {
    let res = await fs.readFileSync('./format/' + name, 'utf8');
    res = res.split('\n')
    // if (res[0].includes('Open_Price')) {
    //     return
    // }
    let header = 'Ticket,Open_Time,Type,Symbol,Open_Price,Close_Price,Close_Time,dPrfPipWrtOpPrPc,dAgeHiPrfInPrPc_RunUpPc,dAgeLoPrfInPrPc_DrawDownPc,openunix,closeunix\r'
    res[0] = header
    for (let i = 1; i < res.length; i++) {
        res[i] = res[i].replace('\r', '')
        let temp = res[i].split(',')
        let openTime = temp[1]
        let closeTime = temp[6]

        openTime = moment.tz(openTime, 'YYYY.MM.DD HH:mm:ss', 'GMT').unix()
        closeTime = moment.tz(closeTime, 'YYYY.MM.DD HH:mm:ss', 'GMT').unix()
        //  console.log(openTime)
        res[i] = res[i] + ',' + openTime + ',' + closeTime + '\r'

        // console.log(temp[6])
    }
    let t = ''
    for (let i = 0; i < res.length; i++)
        t = t + res[i]
    await createFile(name, t)
   // console.log(res)
}

function createFile(name, body) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('files/' + name, body, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}