let fs = require('fs')
let _ = require('lodash')

run()

async function run() {

    let configs = await fs.readdirSync('uniq/')
    let arr = []
    let arrDate = []
    let levels=[]
    for (let i = 0; i < configs.length; i++) {

        if (!configs[i].includes('.json'))
            continue

        let config = await fs.readFileSync('./uniq/' + configs[i], 'utf8')
        config = JSON.parse(config)


        for (let j = 0; j < config.length; j++) {
            levels.push(config[j].maxLevel)
            let dateString = config[j].dateString.split('_')

            for (let z = 0; z < dateString.length-1; z++)
                arrDate.push(dateString[z])
            arr.push(config[j])
        }


    }

    //  console.log(arr)

    arr = _.uniqBy(arr, 'platform');
    arrDate = _.uniq(arrDate);
    let uniqLevels = _.uniq(levels);
    arrDate = _.orderBy(arrDate)
    let levelSort=[]
    for (let i=0;i<uniqLevels.length;i++)
    {
        let counter=0
        for (let j=0;j<levels.length;j++)
            if (uniqLevels[i] === levels[j])
                counter++
        levelSort.push({level:uniqLevels[i],count:counter})
    }


    console.log('All Uniq Platform:' + arr.length)
    console.log('All Uniq Date:' + arrDate.length)
    console.log(arrDate)
    console.log(levelSort)
    let levelBaseDays=[]
    for(let l=0;l<uniqLevels.length;l++)
    {
        let levelInline=[]
        for (let i = 0; i < configs.length; i++) {

            if (!configs[i].includes('.json'))
                continue

            let config = await fs.readFileSync('./uniq/' + configs[i], 'utf8')
            config = JSON.parse(config)


            for (let j = 0; j < config.length; j++) {
               if (config[j].maxLevel ===uniqLevels[l])
               {
                   let dateString = config[j].dateString.split('_')

                   for (let z = 0; z < dateString.length-1; z++)
                       levelInline.push(dateString[z])

               }

            }
            levelInline=_.uniq(levelInline)
            levelBaseDays.push({level:uniqLevels[l],uniqDaysRun:levelInline.length})


        }
    }

    console.log(levelBaseDays)


}

function createfileADV(data) {
    // console.log(data)
    return new Promise(function (resolve, reject) {
        fs.writeFile('configs/last.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}