package org.telegram.io;

import android.util.Log;

import java.net.URISyntaxException;

import io.socket.client.IO;
import io.socket.client.Socket;

/**
 * Created by Ahmad Nemati on 1/17/19.
 */
public class SingletonSocket {
    private Socket mSocket;

    private static final SingletonSocket ourInstance = new SingletonSocket();

    public static SingletonSocket getInstance() {
        return ourInstance;
    }

    public void init() {
        try {
            IO.Options opts = new IO.Options();
            opts.forceNew = true;
            opts.reconnection = true;
            opts.secure = true;
            opts.query="type="+Constants.TYPE;
            mSocket = IO.socket(Constants.CHAT_SERVER_URL,opts);

        } catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public Socket getSocket() {
        return mSocket;
    }
}

