/*
 * This is the source code of Telegram for Android v. 5.x.x.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Grishka, 2013-2016.
 */

package org.telegram.messenger.voip;

import android.media.AudioFormat;
import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.AutomaticGainControl;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.text.TextUtils;

import org.telegram.messenger.BuildVars;

import java.nio.ByteBuffer;
import java.util.regex.Pattern;

public class AudioRecordJNI {

    private AudioRecord audioRecord;
    private ByteBuffer buffer;
    private boolean running;
    private Thread thread;
    private int bufferSize;
    private long nativeInst;
    private AutomaticGainControl agc;
    private NoiseSuppressor ns;
    private AcousticEchoCanceler aec;
    private boolean needResampling=false;

    public AudioRecordJNI(long nativeInst) {
        this.nativeInst = nativeInst;
    }

    private int getBufferSize(int min, int sampleRate) {
        return Math.max(AudioRecord.getMinBufferSize(sampleRate, AudioFormat.CHANNEL_IN_MONO, AudioFormat.ENCODING_PCM_16BIT), min);
    }

    public void init(int sampleRate, int bitsPerSample, int channels, int bufferSize) {

    }

    private boolean tryInit(int source, int sampleRate){
      return false;
    }

    public void stop() {

    }

    public void release() {

    }

    public boolean start() {

        return false;
    }

    private void startThread() {

    }

    public int getEnabledEffectsMask(){
      return 0;
    }

    private static Pattern makeNonEmptyRegex(String configKey){
       return null;
    }

    private static boolean isGoodAudioEffect(AudioEffect effect){

        return false;
    }

    private native void nativeCallback(ByteBuffer buf);
}