/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.graphics.Paint;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.ScrollView;
import android.widget.TextView;

public class FeedbackView
extends LinearLayout {
    public static final int LAST_UPDATED_TEXT_VIEW_ID = 8192;
    public static final int NAME_EDIT_TEXT_ID = 8194;
    public static final int EMAIL_EDIT_TEXT_ID = 8196;
    public static final int SUBJECT_EDIT_TEXT_ID = 8198;
    public static final int TEXT_EDIT_TEXT_ID = 8200;
    public static final int SEND_FEEDBACK_BUTTON_ID = 8201;
    public static final int ADD_RESPONSE_BUTTON_ID = 131088;
    public static final int REFRESH_BUTTON_ID = 131089;
    public static final int WRAPPER_BASE_ID = 131090;
    public static final int WRAPPER_LAYOUT_FEEDBACK_ID = 131091;
    public static final int WRAPPER_LAYOUT_BUTTONS_ID = 131092;
    public static final int WRAPPER_LAYOUT_FEEDBACK_AND_MESSAGES_ID = 131093;
    public static final int MESSAGES_LISTVIEW_ID = 131094;
    public static final int FEEDBACK_SCROLLVIEW_ID = 131095;
    private LinearLayout wrapperBase;
    private ScrollView feedbackScrollView;
    private LinearLayout wrapperLayoutFeedback;
    private LinearLayout wrapperLayoutFeedbackAndMessages;
    private LinearLayout wrapperLayoutButtons;
    private ListView messagesListView;

    public FeedbackView(Context context) {
        super(context);
        this.loadLayoutParams(context);
        this.loadWrapperBase(context);
        this.loadFeedbackScrollView(context);
        this.loadWrapperLayoutFeedback(context);
        this.loadWrapperLayoutFeedbackAndMessages(context);
        this.loadNameInput(context);
        this.loadEmailInput(context);
        this.loadSubjectInput(context);
        this.loadTextInput(context);
        this.loadSendFeedbackButton(context);
        this.loadLastUpdatedLabel(context);
        this.loadWrapperLayoutButtons(context);
        this.loadAddResponseButton(context);
        this.loadRefreshButton(context);
        this.loadMessagesListView(context);
    }

    private void loadLayoutParams(Context context) {
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        this.setBackgroundColor(-1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void loadWrapperBase(Context context) {
        this.wrapperBase = new LinearLayout(context);
        this.wrapperBase.setId(131090);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.gravity = 49;
        this.wrapperBase.setLayoutParams((ViewGroup.LayoutParams)params);
        this.wrapperBase.setPadding(0, padding, 0, padding);
        this.wrapperBase.setOrientation(1);
        this.addView((View)this.wrapperBase);
    }

    private void loadFeedbackScrollView(Context context) {
        this.feedbackScrollView = new ScrollView(context);
        this.feedbackScrollView.setId(131095);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.gravity = 17;
        this.feedbackScrollView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.feedbackScrollView.setPadding(padding, padding, padding, padding);
        this.wrapperBase.addView((View)this.feedbackScrollView);
    }

    private void loadWrapperLayoutFeedback(Context context) {
        this.wrapperLayoutFeedback = new LinearLayout(context);
        this.wrapperLayoutFeedback.setId(131091);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.gravity = 3;
        this.wrapperLayoutFeedback.setLayoutParams((ViewGroup.LayoutParams)params);
        this.wrapperLayoutFeedback.setPadding(padding, padding, padding, padding);
        this.wrapperLayoutFeedback.setGravity(48);
        this.wrapperLayoutFeedback.setOrientation(1);
        this.feedbackScrollView.addView((View)this.wrapperLayoutFeedback);
    }

    private void loadWrapperLayoutFeedbackAndMessages(Context context) {
        this.wrapperLayoutFeedbackAndMessages = new LinearLayout(context);
        this.wrapperLayoutFeedbackAndMessages.setId(131093);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.gravity = 17;
        this.wrapperLayoutFeedbackAndMessages.setLayoutParams((ViewGroup.LayoutParams)params);
        this.wrapperLayoutFeedbackAndMessages.setPadding(padding, padding, padding, padding);
        this.wrapperLayoutFeedbackAndMessages.setGravity(48);
        this.wrapperLayoutFeedbackAndMessages.setOrientation(1);
        this.wrapperBase.addView((View)this.wrapperLayoutFeedbackAndMessages);
    }

    private void loadWrapperLayoutButtons(Context context) {
        this.wrapperLayoutButtons = new LinearLayout(context);
        this.wrapperLayoutButtons.setId(131092);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.gravity = 3;
        this.wrapperLayoutButtons.setLayoutParams((ViewGroup.LayoutParams)params);
        this.wrapperLayoutButtons.setPadding(0, padding, 0, padding);
        this.wrapperLayoutButtons.setGravity(48);
        this.wrapperLayoutButtons.setOrientation(0);
        this.wrapperLayoutFeedbackAndMessages.addView((View)this.wrapperLayoutButtons);
    }

    private void loadMessagesListView(Context context) {
        this.messagesListView = new ListView(context);
        this.messagesListView.setId(131094);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -1);
        int padding = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.messagesListView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.messagesListView.setPadding(0, padding, 0, padding);
        this.wrapperLayoutFeedbackAndMessages.addView((View)this.messagesListView);
    }

    private void loadNameInput(Context context) {
        EditText editText = new EditText(context);
        editText.setId(8194);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(0, 0, 0, margin);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setImeOptions(5);
        editText.setInputType(16385);
        editText.setSingleLine(true);
        editText.setTextColor(-7829368);
        editText.setTextSize(2, 15.0f);
        editText.setTypeface(null, 0);
        editText.setHint((CharSequence)"Name");
        editText.setHintTextColor(-3355444);
        this.setEditTextBackground(context, editText);
        this.wrapperLayoutFeedback.addView((View)editText);
    }

    private void loadEmailInput(Context context) {
        EditText editText = new EditText(context);
        editText.setId(8196);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(0, 0, 0, margin);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setImeOptions(5);
        editText.setInputType(33);
        editText.setSingleLine(true);
        editText.setTextColor(-7829368);
        editText.setTextSize(2, 15.0f);
        editText.setTypeface(null, 0);
        editText.setHint((CharSequence)"Email");
        editText.setHintTextColor(-3355444);
        this.setEditTextBackground(context, editText);
        this.wrapperLayoutFeedback.addView((View)editText);
    }

    private void loadSubjectInput(Context context) {
        EditText editText = new EditText(context);
        editText.setId(8198);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(0, 0, 0, margin);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setImeOptions(5);
        editText.setInputType(16433);
        editText.setSingleLine(true);
        editText.setTextColor(-7829368);
        editText.setTextSize(2, 15.0f);
        editText.setTypeface(null, 0);
        editText.setHint((CharSequence)"Subject");
        editText.setHintTextColor(-3355444);
        this.setEditTextBackground(context, editText);
        this.wrapperLayoutFeedback.addView((View)editText);
    }

    private void loadTextInput(Context context) {
        EditText editText = new EditText(context);
        editText.setId(8200);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int minEditTextHeight = (int)TypedValue.applyDimension((int)1, (float)100.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(0, 0, 0, margin);
        editText.setLayoutParams((ViewGroup.LayoutParams)params);
        editText.setImeOptions(5);
        editText.setInputType(16385);
        editText.setSingleLine(false);
        editText.setTextColor(-7829368);
        editText.setTextSize(2, 15.0f);
        editText.setTypeface(null, 0);
        editText.setMinimumHeight(minEditTextHeight);
        editText.setHint((CharSequence)"Message");
        editText.setHintTextColor(-3355444);
        this.setEditTextBackground(context, editText);
        this.wrapperLayoutFeedback.addView((View)editText);
    }

    private void loadLastUpdatedLabel(Context context) {
        TextView textView = new TextView(context);
        textView.setId(8192);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(0, 0, 0, 0);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setPadding(0, margin, 0, margin);
        textView.setEllipsize(TextUtils.TruncateAt.END);
        textView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        textView.setSingleLine(true);
        textView.setText((CharSequence)"Last Updated: ");
        textView.setTextColor(-7829368);
        textView.setTextSize(2, 15.0f);
        textView.setTypeface(null, 0);
        this.wrapperLayoutFeedbackAndMessages.addView((View)textView);
    }

    private void loadSendFeedbackButton(Context context) {
        Button button = new Button(context);
        button.setId(8201);
        int paddingTopBottom = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int paddingLeftRight = (int)TypedValue.applyDimension((int)1, (float)30.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, 0, margin);
        params.gravity = 1;
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundDrawable(this.getButtonSelector());
        button.setPadding(paddingLeftRight, paddingTopBottom, paddingLeftRight, paddingTopBottom);
        button.setText((CharSequence)"Send feedback");
        button.setTextColor(-1);
        button.setTextSize(2, 15.0f);
        this.wrapperLayoutFeedback.addView((View)button);
    }

    private void loadAddResponseButton(Context context) {
        Button button = new Button(context);
        button.setId(131088);
        int paddingTopBottom = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int marginRight = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(0, 0, marginRight, margin);
        params.gravity = 1;
        params.weight = 1.0f;
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundDrawable(this.getButtonSelector());
        button.setPadding(0, paddingTopBottom, 0, paddingTopBottom);
        button.setGravity(17);
        button.setText((CharSequence)"Add a Response");
        button.setTextColor(-1);
        button.setTextSize(2, 15.0f);
        this.wrapperLayoutButtons.addView((View)button);
    }

    private void loadRefreshButton(Context context) {
        Button button = new Button(context);
        button.setId(131089);
        int paddingTopBottom = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int margin = (int)TypedValue.applyDimension((int)1, (float)10.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        int marginLeft = (int)TypedValue.applyDimension((int)1, (float)5.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-1, -2);
        params.setMargins(marginLeft, 0, 0, margin);
        params.gravity = 1;
        button.setLayoutParams((ViewGroup.LayoutParams)params);
        button.setBackgroundDrawable(this.getButtonSelector());
        button.setPadding(0, paddingTopBottom, 0, paddingTopBottom);
        button.setGravity(17);
        button.setText((CharSequence)"Refresh");
        button.setTextColor(-1);
        button.setTextSize(2, 15.0f);
        params.weight = 1.0f;
        this.wrapperLayoutButtons.addView((View)button);
    }

    private Drawable getButtonSelector() {
        StateListDrawable drawable = new StateListDrawable();
        drawable.addState(new int[]{-16842919}, (Drawable)new ColorDrawable(-16777216));
        drawable.addState(new int[]{-16842919, 16842908}, (Drawable)new ColorDrawable(-12303292));
        drawable.addState(new int[]{16842919}, (Drawable)new ColorDrawable(-7829368));
        return drawable;
    }

    private void setEditTextBackground(Context context, EditText editText) {
        if (Build.VERSION.SDK_INT < 11) {
            editText.setBackgroundDrawable(this.getEditTextBackground(context));
        }
    }

    private Drawable getEditTextBackground(Context context) {
        int outerPadding = (int)(context.getResources().getDisplayMetrics().density * 10.0f);
        ShapeDrawable outerShape = new ShapeDrawable((Shape)new RectShape());
        Paint outerPaint = outerShape.getPaint();
        outerPaint.setColor(-1);
        outerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        outerPaint.setStrokeWidth(1.0f);
        outerShape.setPadding(outerPadding, outerPadding, outerPadding, outerPadding);
        int innerPadding = (int)((double)context.getResources().getDisplayMetrics().density * 1.5);
        ShapeDrawable innerShape = new ShapeDrawable((Shape)new RectShape());
        Paint innerPaint = innerShape.getPaint();
        innerPaint.setColor(-12303292);
        innerPaint.setStyle(Paint.Style.FILL_AND_STROKE);
        innerPaint.setStrokeWidth(1.0f);
        innerShape.setPadding(0, 0, 0, innerPadding);
        return new LayerDrawable(new Drawable[]{innerShape, outerShape});
    }
}

