/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.os.Process;
import android.util.Log;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.UUID;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.CrashManagerListener;

public class ExceptionHandler
implements Thread.UncaughtExceptionHandler {
    private boolean ignoreDefaultHandler = false;
    private CrashManagerListener listener;
    private Thread.UncaughtExceptionHandler defaultExceptionHandler;

    public ExceptionHandler(Thread.UncaughtExceptionHandler defaultExceptionHandler, CrashManagerListener listener, boolean ignoreDefaultHandler) {
        this.defaultExceptionHandler = defaultExceptionHandler;
        this.ignoreDefaultHandler = ignoreDefaultHandler;
        this.listener = listener;
    }

    public void setListener(CrashManagerListener listener) {
        this.listener = listener;
    }

    public static void saveException(Throwable exception, CrashManagerListener listener) {
        Date now = new Date();
        StringWriter result = new StringWriter();
        PrintWriter printWriter = new PrintWriter(result);
        exception.printStackTrace(printWriter);
        try {
            String filename = UUID.randomUUID().toString();
            String path = Constants.FILES_PATH + "/" + filename + ".stacktrace";
            Log.d((String)"HockeyApp", (String)("Writing unhandled exception to: " + path));
            BufferedWriter write = new BufferedWriter(new FileWriter(path));
            write.write("Package: " + Constants.APP_PACKAGE + "\n");
            write.write("Version: " + Constants.APP_VERSION + "\n");
            if (listener == null || listener.includeDeviceData()) {
                write.write("Android: " + Constants.ANDROID_VERSION + "\n");
                write.write("Manufacturer: " + Constants.PHONE_MANUFACTURER + "\n");
                write.write("Model: " + Constants.PHONE_MODEL + "\n");
            }
            write.write("Date: " + now + "\n");
            write.write("\n");
            write.write(((Object)result).toString());
            write.flush();
            write.close();
            if (listener != null) {
                ExceptionHandler.writeValueToFile(ExceptionHandler.limitedString(listener.getUserID()), filename + ".user");
                ExceptionHandler.writeValueToFile(ExceptionHandler.limitedString(listener.getContact()), filename + ".contact");
                ExceptionHandler.writeValueToFile(listener.getDescription(), filename + ".description");
            }
        }
        catch (Exception another) {
            Log.e((String)"HockeyApp", (String)"Error saving exception stacktrace!\n", (Throwable)another);
        }
    }

    public void uncaughtException(Thread thread, Throwable exception) {
        if (Constants.FILES_PATH == null) {
            this.defaultExceptionHandler.uncaughtException(thread, exception);
        } else {
            ExceptionHandler.saveException(exception, this.listener);
            if (!this.ignoreDefaultHandler) {
                this.defaultExceptionHandler.uncaughtException(thread, exception);
            } else {
                Process.killProcess((int)Process.myPid());
                System.exit(10);
            }
        }
    }

    private static void writeValueToFile(String value, String filename) {
        try {
            String path = Constants.FILES_PATH + "/" + filename;
            if (value.trim().length() > 0) {
                BufferedWriter writer = new BufferedWriter(new FileWriter(path));
                writer.write(value);
                writer.flush();
                writer.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String limitedString(String string) {
        if (string != null && string.length() > 255) {
            string = string.substring(0, 255);
        }
        return string;
    }
}

