/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.content.Context;
import android.content.Intent;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.FeedbackActivity;
import net.hockeyapp.android.FeedbackManagerListener;

public class FeedbackManager {
    private static String identifier = null;
    private static String urlString = null;
    private static FeedbackManagerListener lastListener = null;

    public static void register(Context context, String appIdentifier) {
        FeedbackManager.register(context, appIdentifier, null);
    }

    public static void register(Context context, String appIdentifier, FeedbackManagerListener listener) {
        FeedbackManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void register(Context context, String urlString, String appIdentifier, FeedbackManagerListener listener) {
        if (context != null) {
            identifier = appIdentifier;
            FeedbackManager.urlString = urlString;
            lastListener = listener;
            Constants.loadFromContext(context);
        }
    }

    public static void unregister() {
        lastListener = null;
    }

    public static void showFeedbackActivity(Context context) {
        if (context != null) {
            Class<? extends FeedbackActivity> activityClass = null;
            if (lastListener != null) {
                activityClass = lastListener.getFeedbackActivityClass();
            }
            if (activityClass == null) {
                activityClass = FeedbackActivity.class;
            }
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            intent.setClass(context, activityClass);
            intent.putExtra("url", FeedbackManager.getURLString(context));
            context.startActivity(intent);
        }
    }

    private static String getURLString(Context context) {
        return urlString + "api/2/apps/" + identifier + "/feedback/";
    }

    public static FeedbackManagerListener getLastListener() {
        return lastListener;
    }
}

