/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

public class FeedbackMessageView
extends LinearLayout {
    public static final int AUTHOR_TEXT_VIEW_ID = 12289;
    public static final int DATE_TEXT_VIEW_ID = 12290;
    public static final int MESSAGE_TEXT_VIEW_ID = 12291;
    private TextView authorTextView;
    private TextView dateTextView;
    private TextView messageTextView;
    private boolean ownMessage;

    public FeedbackMessageView(Context context) {
        this(context, true);
    }

    public FeedbackMessageView(Context context, boolean ownMessage) {
        super(context);
        this.ownMessage = ownMessage;
        this.loadLayoutParams(context);
        this.loadAuthorLabel(context);
        this.loadDateLabel(context);
        this.loadMessageLabel(context);
    }

    private void loadLayoutParams(Context context) {
        this.setOrientation(1);
        this.setGravity(3);
        this.setBackgroundColor(-3355444);
    }

    private void loadAuthorLabel(Context context) {
        this.authorTextView = new TextView(context);
        this.authorTextView.setId(12289);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(margin, margin, margin, 0);
        this.authorTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.authorTextView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        this.authorTextView.setSingleLine(true);
        this.authorTextView.setTextColor(-7829368);
        this.authorTextView.setTextSize(2, 15.0f);
        this.authorTextView.setTypeface(null, 0);
        this.addView((View)this.authorTextView);
    }

    public void setAuthorLabelText(String name) {
        if (this.authorTextView != null && name != null) {
            this.authorTextView.setText((CharSequence)name);
        }
    }

    private void setAuthorLaberColor(int color) {
        if (this.authorTextView != null) {
            this.authorTextView.setTextColor(color);
        }
    }

    private void loadDateLabel(Context context) {
        this.dateTextView = new TextView(context);
        this.dateTextView.setId(12290);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(margin, 0, margin, 0);
        this.dateTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.dateTextView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        this.dateTextView.setSingleLine(true);
        this.dateTextView.setTextColor(-7829368);
        this.dateTextView.setTextSize(2, 15.0f);
        this.dateTextView.setTypeface(null, 2);
        this.addView((View)this.dateTextView);
    }

    public void setDateLabelText(String text) {
        if (this.dateTextView != null && text != null) {
            this.dateTextView.setText((CharSequence)text);
        }
    }

    private void setDateLaberColor(int color) {
        if (this.dateTextView != null) {
            this.dateTextView.setTextColor(color);
        }
    }

    private void loadMessageLabel(Context context) {
        this.messageTextView = new TextView(context);
        this.messageTextView.setId(12291);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(-2, -2);
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        params.setMargins(margin, 0, margin, margin);
        this.messageTextView.setLayoutParams((ViewGroup.LayoutParams)params);
        this.messageTextView.setShadowLayer(1.0f, 0.0f, 1.0f, -1);
        this.messageTextView.setSingleLine(false);
        this.messageTextView.setTextColor(-16777216);
        this.messageTextView.setTextSize(2, 18.0f);
        this.messageTextView.setTypeface(null, 0);
        this.addView((View)this.messageTextView);
    }

    public void setMessageLabelText(String text) {
        if (this.messageTextView != null && text != null) {
            this.messageTextView.setText((CharSequence)text);
        }
    }

    private void setMessageLaberColor(int color) {
        if (this.messageTextView != null) {
            this.messageTextView.setTextColor(color);
        }
    }

    public void setFeedbackMessageViewBgAndTextColor(int decisionValue) {
        if (decisionValue == 0) {
            this.setBackgroundColor(-3355444);
            this.setAuthorLaberColor(-1);
            this.setDateLaberColor(-1);
        } else if (decisionValue == 1) {
            this.setBackgroundColor(-1);
            this.setAuthorLaberColor(-3355444);
            this.setDateLaberColor(-3355444);
        }
        this.setMessageLaberColor(-16777216);
    }
}

