/*
 * This is the source code of Telegram for Android v. 1.3.2.
 * It is licensed under GNU GPL v. 2 or later.
 * You should have received a copy of the license in this archive (see LICENSE).
 *
 * Copyright Nikolai Kudashov, 2013.
 */

package org.telegram.messenger;

import android.net.Uri;
import android.util.Log;

import org.telegram.ui.ApplicationLoader;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Locale;

public class FileLog {
    public static FileLog Instance = new FileLog();
    private OutputStreamWriter streamWriter = null;
    private FastDateFormat dateFormat = null;
    private DispatchQueue logQueue = null;
    private File currentFile = null;

    public FileLog() {
        if (!ConnectionsManager.DEBUG_VERSION) {
            return;
        }
        dateFormat = FastDateFormat.getInstance("dd_MM_yyyy_HH_mm_ss", Locale.US);
        File sdCard = ApplicationLoader.applicationContext.getExternalFilesDir(null);
        if (sdCard == null) {
            return;
        }
        File dir = new File(sdCard.getAbsolutePath() + "/logs");
        if (dir == null) {
            return;
        }
        dir.mkdirs();
        currentFile = new File(dir, dateFormat.format(System.currentTimeMillis()) + ".txt");
        if (currentFile == null) {
            return;
        }
        try {
            currentFile.createNewFile();
            FileOutputStream stream = new FileOutputStream(currentFile);
            streamWriter = new OutputStreamWriter(stream);
            streamWriter.write("-----start log " + dateFormat.format(System.currentTimeMillis()) + "-----\n");
            streamWriter.flush();
            logQueue = new DispatchQueue("logQueue");
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void e(final String tag, final String message, final Throwable exception) {
        if (!ConnectionsManager.DEBUG_VERSION) {
            return;
        }
        Log.e(tag, message, exception);
        if (Instance.streamWriter != null) {
            Instance.logQueue.postRunnable(new Runnable() {
                @Override
                public void run() {
                    try {
                        Instance.streamWriter.write(Instance.dateFormat.format(System.currentTimeMillis()) + " E/" + tag + "﹕ " + message + "\n");
                        Instance.streamWriter.write(exception.toString());
                        Instance.streamWriter.flush();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void e(final String tag, final String message) {
        if (!ConnectionsManager.DEBUG_VERSION) {
            return;
        }
        Log.e(tag, message);
        if (Instance.streamWriter != null) {
            Instance.logQueue.postRunnable(new Runnable() {
                @Override
                public void run() {
                    try {
                        Instance.streamWriter.write(Instance.dateFormat.format(System.currentTimeMillis()) + " E/" + tag + "﹕ " + message + "\n");
                        Instance.streamWriter.flush();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void e(final String tag, final Exception e) {
        if (!ConnectionsManager.DEBUG_VERSION) {
            return;
        }
        e.printStackTrace();
        if (Instance.streamWriter != null) {
            Instance.logQueue.postRunnable(new Runnable() {
                @Override
                public void run() {
                    try {
                        Instance.streamWriter.write(Instance.dateFormat.format(System.currentTimeMillis()) + " E/" + tag + "﹕ " + e + "\n");
                        StackTraceElement[] stack = e.getStackTrace();
                        for (StackTraceElement el : stack) {
                            Instance.streamWriter.write(Instance.dateFormat.format(System.currentTimeMillis()) + " E/" + tag + "﹕ " + el + "\n");
                        }
                        Instance.streamWriter.flush();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        } else {
            e.printStackTrace();
        }
    }

    public static void d(final String tag, final String message) {
        if (!ConnectionsManager.DEBUG_VERSION) {
            return;
        }
        Log.d(tag, message);
        if (Instance.streamWriter != null) {
            Instance.logQueue.postRunnable(new Runnable() {
                @Override
                public void run() {
                    try {
                        Instance.streamWriter.write(Instance.dateFormat.format(System.currentTimeMillis()) + " D/" + tag + "﹕ " + message + "\n");
                        Instance.streamWriter.flush();
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public static void cleanupLogs() {
        ArrayList<Uri> uris = new ArrayList<Uri>();
        File sdCard = ApplicationLoader.applicationContext.getExternalFilesDir(null);
        File dir = new File (sdCard.getAbsolutePath() + "/logs");
        File[] files = dir.listFiles();
        for (File file : files) {
            if (Instance.currentFile != null && file.getAbsolutePath().equals(Instance.currentFile.getAbsolutePath())) {
                continue;
            }
            file.delete();
        }
    }
}
