/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.CrashManagerListener;
import net.hockeyapp.android.ExceptionHandler;
import net.hockeyapp.android.Strings;
import net.hockeyapp.android.utils.ConnectionManager;
import net.hockeyapp.android.utils.PrefsUtil;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrashManager {
    private static String identifier = null;
    private static String urlString = null;

    public static void register(Context context, String appIdentifier) {
        CrashManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, null);
    }

    public static void register(Context context, String appIdentifier, CrashManagerListener listener) {
        CrashManager.register(context, "https://sdk.hockeyapp.net/", appIdentifier, listener);
    }

    public static void register(Context context, String urlString, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, urlString, appIdentifier, listener, false);
        CrashManager.execute(context, listener);
    }

    public static void initialize(Context context, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, "https://sdk.hockeyapp.net/", appIdentifier, listener, true);
    }

    public static void initialize(Context context, String urlString, String appIdentifier, CrashManagerListener listener) {
        CrashManager.initialize(context, urlString, appIdentifier, listener, true);
    }

    public static void execute(Context context, CrashManagerListener listener) {
        Boolean ignoreDefaultHandler = listener != null && listener.ignoreDefaultHandler();
        WeakReference<Context> weakContext = new WeakReference<Context>(context);
        int foundOrSend = CrashManager.hasStackTraces(weakContext);
        if (foundOrSend == 1) {
            Boolean autoSend = false;
            if (listener != null) {
                autoSend = autoSend | listener.shouldAutoUploadCrashes();
                autoSend = autoSend | listener.onCrashesFound();
                listener.onNewCrashesFound();
            }
            if (!autoSend.booleanValue()) {
                CrashManager.showDialog(weakContext, listener, ignoreDefaultHandler);
            } else {
                CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler);
            }
        } else if (foundOrSend == 2) {
            if (listener != null) {
                listener.onConfirmedCrashesFound();
            }
            CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler);
        } else {
            CrashManager.registerHandler(weakContext, listener, ignoreDefaultHandler);
        }
    }

    public static int hasStackTraces(WeakReference<Context> weakContext) {
        String[] filenames = CrashManager.searchForStackTraces();
        List<String> confirmedFilenames = null;
        int result = 0;
        if (filenames != null && filenames.length > 0) {
            try {
                Context context = null;
                if (weakContext != null && (context = (Context)weakContext.get()) != null) {
                    SharedPreferences preferences = context.getSharedPreferences("HockeySDK", 0);
                    confirmedFilenames = Arrays.asList(preferences.getString("ConfirmedFilenames", "").split("\\|"));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (confirmedFilenames != null) {
                result = 2;
                for (String filename : filenames) {
                    if (confirmedFilenames.contains(filename)) continue;
                    result = 1;
                    break;
                }
            } else {
                result = 1;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void submitStackTraces(WeakReference<Context> weakContext, CrashManagerListener listener) {
        String[] list = CrashManager.searchForStackTraces();
        Boolean successful = false;
        if (list != null && list.length > 0) {
            Log.d((String)"HockeyApp", (String)("Found " + list.length + " stacktrace(s)."));
            for (int index = 0; index < list.length; ++index) {
                try {
                    String filename = list[index];
                    String stacktrace = CrashManager.contentsOfFile(weakContext, filename);
                    if (stacktrace.length() <= 0) continue;
                    Log.d((String)"HockeyApp", (String)("Transmitting crash data: \n" + stacktrace));
                    DefaultHttpClient httpClient = (DefaultHttpClient)ConnectionManager.getInstance().getHttpClient();
                    HttpPost httpPost = new HttpPost(CrashManager.getURLString());
                    ArrayList<BasicNameValuePair> parameters = new ArrayList<BasicNameValuePair>();
                    parameters.add(new BasicNameValuePair("raw", stacktrace));
                    parameters.add(new BasicNameValuePair("userID", CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".user"))));
                    parameters.add(new BasicNameValuePair("contact", CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".contact"))));
                    parameters.add(new BasicNameValuePair("description", CrashManager.contentsOfFile(weakContext, filename.replace(".stacktrace", ".description"))));
                    parameters.add(new BasicNameValuePair("sdk", "HockeySDK"));
                    parameters.add(new BasicNameValuePair("sdk_version", "3.0.1"));
                    httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(parameters, "UTF-8"));
                    httpClient.execute((HttpUriRequest)httpPost);
                    successful = true;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                finally {
                    if (successful.booleanValue()) {
                        CrashManager.deleteStackTrace(weakContext, list[index]);
                        if (listener != null) {
                            listener.onCrashesSent();
                        }
                    } else if (listener != null) {
                        listener.onCrashesNotSent();
                    }
                }
            }
        }
    }

    public static void deleteStackTraces(WeakReference<Context> weakContext) {
        String[] list = CrashManager.searchForStackTraces();
        if (list != null && list.length > 0) {
            Log.d((String)"HockeyApp", (String)("Found " + list.length + " stacktrace(s)."));
            for (int index = 0; index < list.length; ++index) {
                try {
                    Context context = null;
                    if (weakContext == null) continue;
                    Log.d((String)"HockeyApp", (String)("Delete stacktrace " + list[index] + "."));
                    CrashManager.deleteStackTrace(weakContext, list[index]);
                    context = (Context)weakContext.get();
                    if (context == null) continue;
                    context.deleteFile(list[index]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void initialize(Context context, String urlString, String appIdentifier, CrashManagerListener listener, boolean registerHandler) {
        if (context != null) {
            CrashManager.urlString = urlString;
            identifier = appIdentifier;
            Constants.loadFromContext(context);
            if (identifier == null) {
                identifier = Constants.APP_PACKAGE;
            }
            if (registerHandler) {
                Boolean ignoreDefaultHandler = listener != null && listener.ignoreDefaultHandler();
                WeakReference<Context> weakContext = new WeakReference<Context>(context);
                CrashManager.registerHandler(weakContext, listener, ignoreDefaultHandler);
            }
        }
    }

    private static void showDialog(final WeakReference<Context> weakContext, final CrashManagerListener listener, final boolean ignoreDefaultHandler) {
        Context context = null;
        if (weakContext != null) {
            context = (Context)weakContext.get();
        }
        if (context == null) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle((CharSequence)Strings.get(listener, 0));
        builder.setMessage((CharSequence)Strings.get(listener, 1));
        builder.setNegativeButton((CharSequence)Strings.get(listener, 2), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (listener != null) {
                    listener.onUserDeniedCrashes();
                }
                CrashManager.deleteStackTraces(weakContext);
                CrashManager.registerHandler(weakContext, listener, ignoreDefaultHandler);
            }
        });
        builder.setPositiveButton((CharSequence)Strings.get(listener, 3), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CrashManager.sendCrashes(weakContext, listener, ignoreDefaultHandler);
            }
        });
        builder.create().show();
    }

    private static void sendCrashes(final WeakReference<Context> weakContext, final CrashManagerListener listener, final boolean ignoreDefaultHandler) {
        CrashManager.saveConfirmedStackTraces(weakContext);
        new Thread(){

            public void run() {
                CrashManager.submitStackTraces(weakContext, listener);
                CrashManager.registerHandler(weakContext, listener, ignoreDefaultHandler);
            }
        }.start();
    }

    private static void registerHandler(WeakReference<Context> weakContext, CrashManagerListener listener, boolean ignoreDefaultHandler) {
        if (Constants.APP_VERSION != null && Constants.APP_PACKAGE != null) {
            Thread.UncaughtExceptionHandler currentHandler = Thread.getDefaultUncaughtExceptionHandler();
            if (currentHandler != null) {
                Log.d((String)"HockeyApp", (String)("Current handler class = " + currentHandler.getClass().getName()));
            }
            if (currentHandler instanceof ExceptionHandler) {
                ((ExceptionHandler)currentHandler).setListener(listener);
            } else {
                Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler(currentHandler, listener, ignoreDefaultHandler));
            }
        } else {
            Log.d((String)"HockeyApp", (String)"Exception handler not set because version or package is null.");
        }
    }

    private static String getURLString() {
        return urlString + "api/2/apps/" + identifier + "/crashes/";
    }

    private static void deleteStackTrace(WeakReference<Context> weakContext, String filename) {
        Context context = null;
        if (weakContext != null && (context = (Context)weakContext.get()) != null) {
            context.deleteFile(filename);
            String user = filename.replace(".stacktrace", ".user");
            context.deleteFile(user);
            String contact = filename.replace(".stacktrace", ".contact");
            context.deleteFile(contact);
            String description = filename.replace(".stacktrace", ".description");
            context.deleteFile(description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String contentsOfFile(WeakReference<Context> weakContext, String filename) {
        Context context = null;
        if (weakContext != null && (context = (Context)weakContext.get()) != null) {
            StringBuilder contents = new StringBuilder();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(context.openFileInput(filename)));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    contents.append(line);
                    contents.append(System.getProperty("line.separator"));
                }
            }
            catch (FileNotFoundException e) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ignored) {}
                }
            }
            return contents.toString();
        }
        return null;
    }

    private static void saveConfirmedStackTraces(WeakReference<Context> weakContext) {
        Context context = null;
        if (weakContext != null && (context = (Context)weakContext.get()) != null) {
            try {
                String[] filenames = CrashManager.searchForStackTraces();
                SharedPreferences preferences = context.getSharedPreferences("HockeySDK", 0);
                SharedPreferences.Editor editor = preferences.edit();
                editor.putString("ConfirmedFilenames", CrashManager.joinArray(filenames, "|"));
                PrefsUtil.applyChanges(editor);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static String joinArray(String[] array, String delimiter) {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < array.length; ++index) {
            buffer.append(array[index]);
            if (index >= array.length - 1) continue;
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    private static String[] searchForStackTraces() {
        if (Constants.FILES_PATH != null) {
            Log.d((String)"HockeyApp", (String)("Looking for exceptions in: " + Constants.FILES_PATH));
            File dir = new File(Constants.FILES_PATH + "/");
            boolean created = dir.mkdir();
            if (!created && !dir.exists()) {
                return new String[0];
            }
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.endsWith(".stacktrace");
                }
            };
            return dir.list(filter);
        }
        Log.d((String)"HockeyApp", (String)"Can't search for exception as file path is null.");
        return null;
    }
}

