/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android;

import android.app.Activity;
import android.content.Context;
import android.content.SharedPreferences;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.utils.PrefsUtil;

public class Tracking {
    private static final String START_TIME_KEY = "startTime";
    private static final String USAGE_TIME_KEY = "usageTime";

    public static void startUsage(Activity activity) {
        long now = System.currentTimeMillis();
        if (activity == null) {
            return;
        }
        SharedPreferences.Editor editor = Tracking.getPreferences((Context)activity).edit();
        editor.putLong(START_TIME_KEY + activity.hashCode(), now);
        PrefsUtil.applyChanges(editor);
    }

    public static void stopUsage(Activity activity) {
        long now = System.currentTimeMillis();
        if (activity == null) {
            return;
        }
        if (!Tracking.checkVersion((Context)activity)) {
            return;
        }
        SharedPreferences preferences = Tracking.getPreferences((Context)activity);
        long start = preferences.getLong(START_TIME_KEY + activity.hashCode(), 0L);
        long sum = preferences.getLong(USAGE_TIME_KEY + Constants.APP_VERSION, 0L);
        if (start > 0L) {
            long duration = now - start;
            SharedPreferences.Editor editor = preferences.edit();
            editor.putLong(USAGE_TIME_KEY + Constants.APP_VERSION, sum + duration);
            PrefsUtil.applyChanges(editor);
        }
    }

    public static long getUsageTime(Context context) {
        if (!Tracking.checkVersion(context)) {
            return 0L;
        }
        SharedPreferences preferences = Tracking.getPreferences(context);
        long sum = preferences.getLong(USAGE_TIME_KEY + Constants.APP_VERSION, 0L);
        return sum / 1000L;
    }

    private static boolean checkVersion(Context context) {
        if (Constants.APP_VERSION == null) {
            Constants.loadFromContext(context);
            if (Constants.APP_VERSION == null) {
                return false;
            }
        }
        return true;
    }

    private static SharedPreferences getPreferences(Context context) {
        return context.getSharedPreferences("HockeyApp", 0);
    }
}

