/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.adapters;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import net.hockeyapp.android.objects.FeedbackMessage;
import net.hockeyapp.android.views.FeedbackMessageView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagesAdapter
extends BaseAdapter {
    private Context context;
    private ArrayList<FeedbackMessage> messagesList;
    private SimpleDateFormat format;
    private SimpleDateFormat formatNew;
    private Date date;
    private TextView authorTextView;
    private TextView dateTextView;
    private TextView messageTextView;

    public MessagesAdapter(Context context, ArrayList<FeedbackMessage> messagesList) {
        this.context = context;
        this.messagesList = messagesList;
        this.format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        this.formatNew = new SimpleDateFormat("d MMM h:mm a");
    }

    public int getCount() {
        return this.messagesList.size();
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        FeedbackMessage feedbackMessage = this.messagesList.get(position);
        FeedbackMessageView view = convertView == null ? new FeedbackMessageView(this.context) : (FeedbackMessageView)convertView;
        if (feedbackMessage != null) {
            this.authorTextView = (TextView)view.findViewById(12289);
            this.dateTextView = (TextView)view.findViewById(12290);
            this.messageTextView = (TextView)view.findViewById(12291);
            try {
                this.date = this.format.parse(feedbackMessage.getCreatedAt());
                this.dateTextView.setText((CharSequence)this.formatNew.format(this.date));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            this.authorTextView.setText((CharSequence)feedbackMessage.getName());
            this.messageTextView.setText((CharSequence)feedbackMessage.getText());
        }
        view.setFeedbackMessageViewBgAndTextColor(position % 2 == 0 ? 0 : 1);
        return view;
    }

    public Object getItem(int position) {
        return this.messagesList.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public void clear() {
        if (this.messagesList != null) {
            this.messagesList.clear();
        }
    }

    public void add(FeedbackMessage message) {
        if (message != null && this.messagesList != null) {
            this.messagesList.add(message);
        }
    }
}

