/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.tasks;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.DialogFragment;
import android.app.Fragment;
import android.app.FragmentTransaction;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.AsyncTask;
import android.os.Build;
import android.provider.Settings;
import android.util.Log;
import android.widget.Toast;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Locale;
import net.hockeyapp.android.Constants;
import net.hockeyapp.android.Strings;
import net.hockeyapp.android.Tracking;
import net.hockeyapp.android.UpdateActivity;
import net.hockeyapp.android.UpdateFragment;
import net.hockeyapp.android.UpdateManager;
import net.hockeyapp.android.UpdateManagerListener;
import net.hockeyapp.android.utils.VersionCache;
import net.hockeyapp.android.utils.VersionHelper;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckUpdateTask
extends AsyncTask<String, String, JSONArray> {
    private static final int MAX_NUMBER_OF_VERSIONS = 25;
    protected String urlString = null;
    protected String appIdentifier = null;
    private Activity activity = null;
    private Boolean mandatory = false;
    private UpdateManagerListener listener;
    private long usageTime = 0L;

    public CheckUpdateTask(WeakReference<Activity> weakActivity, String urlString) {
        this.appIdentifier = null;
        this.urlString = urlString;
        if (weakActivity != null) {
            this.activity = (Activity)weakActivity.get();
        }
        if (this.activity != null) {
            this.usageTime = Tracking.getUsageTime((Context)this.activity);
            Constants.loadFromContext((Context)this.activity);
        }
    }

    public CheckUpdateTask(WeakReference<Activity> weakActivity, String urlString, String appIdentifier) {
        this.appIdentifier = appIdentifier;
        this.urlString = urlString;
        if (weakActivity != null) {
            this.activity = (Activity)weakActivity.get();
        }
        if (this.activity != null) {
            this.usageTime = Tracking.getUsageTime((Context)this.activity);
            Constants.loadFromContext((Context)this.activity);
        }
    }

    public CheckUpdateTask(WeakReference<Activity> weakActivity, String urlString, String appIdentifier, UpdateManagerListener listener) {
        this.appIdentifier = appIdentifier;
        this.urlString = urlString;
        this.listener = listener;
        if (weakActivity != null) {
            this.activity = (Activity)weakActivity.get();
        }
        if (this.activity != null) {
            this.usageTime = Tracking.getUsageTime((Context)this.activity);
            Constants.loadFromContext((Context)this.activity);
        }
    }

    public void attach(WeakReference<Activity> weakActivity) {
        if (weakActivity != null) {
            this.activity = (Activity)weakActivity.get();
        }
        if (this.activity != null) {
            Constants.loadFromContext((Context)this.activity);
        }
    }

    public void detach() {
        this.activity = null;
    }

    protected int getVersionCode() {
        return Integer.parseInt(Constants.APP_VERSION);
    }

    protected JSONArray doInBackground(String ... args) {
        try {
            int versionCode = this.getVersionCode();
            JSONArray json = new JSONArray(VersionCache.getVersionInfo((Context)this.activity));
            if (this.getCachingEnabled() && this.findNewVersion(json, versionCode)) {
                return json;
            }
            URL url = new URL(this.getURLString("json"));
            URLConnection connection = this.createConnection(url);
            connection.connect();
            BufferedInputStream inputStream = new BufferedInputStream(connection.getInputStream());
            String jsonString = CheckUpdateTask.convertStreamToString(inputStream);
            ((InputStream)inputStream).close();
            json = new JSONArray(jsonString);
            if (this.findNewVersion(json, versionCode)) {
                json = this.limitResponseSize(json);
                return json;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected URLConnection createConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", "HockeySDK/Android");
        if (Build.VERSION.SDK_INT <= 9) {
            connection.setRequestProperty("connection", "close");
        }
        return connection;
    }

    private boolean findNewVersion(JSONArray json, int versionCode) {
        try {
            for (int index = 0; index < json.length(); ++index) {
                JSONObject entry = json.getJSONObject(index);
                if (entry.getInt("version") <= versionCode || VersionHelper.compareVersionStrings(entry.getString("minimum_os_version"), Build.VERSION.RELEASE) > 0) continue;
                if (entry.has("mandatory")) {
                    this.mandatory = entry.getBoolean("mandatory");
                }
                return true;
            }
            return false;
        }
        catch (JSONException e) {
            return false;
        }
    }

    private JSONArray limitResponseSize(JSONArray json) {
        JSONArray result = new JSONArray();
        for (int index = 0; index < Math.min(json.length(), 25); ++index) {
            try {
                result.put(json.get(index));
                continue;
            }
            catch (JSONException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected void onPostExecute(JSONArray updateInfo) {
        if (updateInfo != null) {
            if (this.listener != null) {
                this.listener.onUpdateAvailable();
            }
            this.showDialog(updateInfo);
        } else if (this.listener != null) {
            this.listener.onNoUpdateAvailable();
        }
    }

    private void cleanUp() {
        this.activity = null;
        this.urlString = null;
        this.appIdentifier = null;
    }

    protected String getURLString(String format) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.urlString);
        builder.append("api/2/apps/");
        builder.append(this.appIdentifier != null ? this.appIdentifier : this.activity.getPackageName());
        builder.append("?format=" + format);
        String deviceIdentifier = Settings.Secure.getString((ContentResolver)this.activity.getContentResolver(), (String)"android_id");
        if (deviceIdentifier != null) {
            builder.append("&udid=" + this.encodeParam(Settings.Secure.getString((ContentResolver)this.activity.getContentResolver(), (String)"android_id")));
        }
        builder.append("&os=Android");
        builder.append("&os_version=" + this.encodeParam(Constants.ANDROID_VERSION));
        builder.append("&device=" + this.encodeParam(Constants.PHONE_MODEL));
        builder.append("&oem=" + this.encodeParam(Constants.PHONE_MANUFACTURER));
        builder.append("&app_version=" + this.encodeParam(Constants.APP_VERSION));
        builder.append("&sdk=" + this.encodeParam("HockeySDK"));
        builder.append("&sdk_version=" + this.encodeParam("3.0.1"));
        builder.append("&lang=" + this.encodeParam(Locale.getDefault().getLanguage()));
        builder.append("&usage_time=" + this.usageTime);
        return builder.toString();
    }

    private String encodeParam(String param) {
        try {
            return URLEncoder.encode(param, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    @TargetApi(value=11)
    private void showDialog(final JSONArray updateInfo) {
        if (this.getCachingEnabled()) {
            VersionCache.setVersionInfo((Context)this.activity, updateInfo.toString());
        }
        if (this.activity == null || this.activity.isFinishing()) {
            return;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.activity);
        builder.setTitle((CharSequence)Strings.get(this.listener, 9));
        if (!this.mandatory.booleanValue()) {
            builder.setMessage((CharSequence)Strings.get(this.listener, 10));
            builder.setNegativeButton((CharSequence)Strings.get(this.listener, 11), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    CheckUpdateTask.this.cleanUp();
                }
            });
            builder.setPositiveButton((CharSequence)Strings.get(this.listener, 12), new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    if (CheckUpdateTask.this.getCachingEnabled()) {
                        VersionCache.setVersionInfo((Context)CheckUpdateTask.this.activity, "[]");
                    }
                    WeakReference<Activity> weakActivity = new WeakReference<Activity>(CheckUpdateTask.this.activity);
                    if (UpdateManager.fragmentsSupported().booleanValue() && UpdateManager.runsOnTablet(weakActivity).booleanValue()) {
                        CheckUpdateTask.this.showUpdateFragment(updateInfo);
                    } else {
                        CheckUpdateTask.this.startUpdateIntent(updateInfo, false);
                    }
                }
            });
            builder.create().show();
        } else {
            Toast.makeText((Context)this.activity, (CharSequence)Strings.get(this.listener, 8), (int)1).show();
            this.startUpdateIntent(updateInfo, true);
        }
    }

    @TargetApi(value=11)
    private void startUpdateIntent(JSONArray updateInfo, Boolean finish) {
        Class<? extends UpdateActivity> activityClass = null;
        if (this.listener != null) {
            activityClass = this.listener.getUpdateActivityClass();
        }
        if (activityClass == null) {
            activityClass = UpdateActivity.class;
        }
        if (this.activity != null) {
            Intent intent = new Intent();
            intent.setClass((Context)this.activity, activityClass);
            intent.putExtra("json", updateInfo.toString());
            intent.putExtra("url", this.getURLString("apk"));
            this.activity.startActivity(intent);
            if (finish.booleanValue()) {
                this.activity.finish();
            }
        }
        this.cleanUp();
    }

    @TargetApi(value=11)
    private void showUpdateFragment(JSONArray updateInfo) {
        if (this.activity != null) {
            FragmentTransaction fragmentTransaction = this.activity.getFragmentManager().beginTransaction();
            fragmentTransaction.setTransition(4097);
            Fragment existingFragment = this.activity.getFragmentManager().findFragmentByTag("hockey_update_dialog");
            if (existingFragment != null) {
                fragmentTransaction.remove(existingFragment);
            }
            fragmentTransaction.addToBackStack(null);
            Class<UpdateFragment> fragmentClass = UpdateFragment.class;
            if (this.listener != null) {
                fragmentClass = this.listener.getUpdateFragmentClass();
            }
            try {
                Method method = fragmentClass.getMethod("newInstance", JSONArray.class, String.class);
                DialogFragment updateFragment = (DialogFragment)method.invoke(null, updateInfo, this.getURLString("apk"));
                updateFragment.show(fragmentTransaction, "hockey_update_dialog");
            }
            catch (Exception e) {
                Log.d((String)"HockeyApp", (String)"An exception happened while showing the update fragment:");
                e.printStackTrace();
                Log.d((String)"HockeyApp", (String)"Showing update activity instead.");
                this.startUpdateIntent(updateInfo, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream inputStream) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream), 1024);
        StringBuilder stringBuilder = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return stringBuilder.toString();
    }

    protected boolean getCachingEnabled() {
        return true;
    }
}

