/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.utils;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.widget.Toast;
import java.lang.ref.WeakReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiThreadUtil {
    private UiThreadUtil() {
    }

    public static UiThreadUtil getInstance() {
        return WbUtilHolder.INSTANCE;
    }

    public void dismissLoadingDialogAndDisplayError(WeakReference<Activity> weakActivity, final ProgressDialog progressDialog, final int errorDialogId) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            activity.runOnUiThread(new Runnable(){

                public void run() {
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dismiss();
                    }
                    activity.showDialog(errorDialogId);
                }
            });
        }
    }

    public void dismissLoading(WeakReference<Activity> weakActivity, final ProgressDialog progressDialog) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            activity.runOnUiThread(new Runnable(){

                public void run() {
                    if (progressDialog != null && progressDialog.isShowing()) {
                        progressDialog.dismiss();
                    }
                }
            });
        }
    }

    public void displayToastMessage(WeakReference<Activity> weakActivity, final String message, final int flags) {
        Activity activity;
        if (weakActivity != null && (activity = (Activity)weakActivity.get()) != null) {
            activity.runOnUiThread(new Runnable(){

                public void run() {
                    Toast.makeText((Context)activity, (CharSequence)message, (int)flags).show();
                }
            });
        }
    }

    private static class WbUtilHolder {
        public static final UiThreadUtil INSTANCE = new UiThreadUtil();

        private WbUtilHolder() {
        }
    }
}

