/*
 * Decompiled with CFR 0.152.
 */
package net.hockeyapp.android.views;

import android.content.Context;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import net.hockeyapp.android.utils.ViewHelper;

public class ExpiryInfoView
extends RelativeLayout {
    public ExpiryInfoView(Context context) {
        this(context, "");
    }

    public ExpiryInfoView(Context context, String text) {
        super(context);
        this.loadLayoutParams(context);
        this.loadShadowView(context);
        this.loadTextView(context, text);
    }

    private void loadLayoutParams(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
        this.setBackgroundColor(-1);
        this.setLayoutParams((ViewGroup.LayoutParams)params);
    }

    private void loadShadowView(Context context) {
        int height = (int)TypedValue.applyDimension((int)1, (float)3.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, height);
        params.addRule(10, -1);
        ImageView shadowView = new ImageView(context);
        shadowView.setLayoutParams((ViewGroup.LayoutParams)params);
        shadowView.setBackgroundDrawable(ViewHelper.getGradient());
        this.addView((View)shadowView);
    }

    private void loadTextView(Context context, String text) {
        int margin = (int)TypedValue.applyDimension((int)1, (float)20.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -2);
        params.addRule(13, -1);
        params.setMargins(margin, margin, margin, margin);
        TextView textView = new TextView(context);
        textView.setGravity(17);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        textView.setText((CharSequence)text);
        textView.setTextColor(-16777216);
        this.addView((View)textView);
    }
}

