// Import required packages
const { exec } = require("child_process");
const otplib = require("otplib");

// Expected length of the secret key
const expectedSecretLength = "ZGQ7DIXAENR5HPXONMYQJQPF2XVYM3OEUM4OBMBMDKRZ5DAVNYNPAISZTD76WML2".length;

// Store the last generated token and clipboard content
let lastToken = "";
let previousSecret = "";

// Function to read the clipboard content on Windows
function readClipboard(callback) {
    exec("powershell Get-Clipboard", (error, stdout) => {
        if (error) {
            console.error("Error reading clipboard:", error);
            return;
        }

        // Pass the clipboard content to the callback function
        callback(stdout.trim());
    });
}

// Function to generate and display the TOTP code if the secret changes
function checkForNewCode(secret) {
    if (secret !== previousSecret) {
        console.log(`Detected new secret key from clipboard: ${secret}`);
        previousSecret = secret;
    }

    // Generate TOTP code using the current secret
    const currentToken = otplib.authenticator.generate(secret);

    // If the current token is different from the last token, log it
    if (currentToken !== lastToken) {
        console.log(`New 2FA code: ${currentToken}`);
        lastToken = currentToken;
    }
}

// Run the clipboard read and TOTP generation every second, only on Windows
if (process.platform === "win32") {
    setInterval(() => {
        // Read the secret from clipboard and generate TOTP code if length matches
        readClipboard((clipboardContent) => {
            if (clipboardContent.length === expectedSecretLength) {
                checkForNewCode(clipboardContent);
            }
            else
                checkForNewCode(previousSecret)

        });
    }, 1000);
} else {
    console.log("This script only runs on Windows.");
}
