// Import required packages
const { exec } = require("child_process");
const otplib = require("otplib");

// List of valid secret lengths
const validSecretLengths = [
    "ZGQ7DIXAENR5HPXONMYQJQPF2XVYM3OEUM4OBMBMDKRZ5DAVNYNPAISZTD76WML2".length,
    "QG5Z22ORKZC46SJRCCOPPEE5K475NHO7".length
];

// Store the last generated token and clipboard content
let lastToken = "";
let previousSecret = "";

// Function to read the clipboard content on Windows
function readClipboard(callback) {
    exec("powershell Get-Clipboard", (error, stdout) => {
        if (error) {
            console.error("Error reading clipboard:", error);
            return;
        }

        // Pass the clipboard content to the callback function
        callback(stdout.trim());
    });
}

// Function to generate and display the TOTP code if the secret changes
function checkForNewCode(secret) {
    if (secret !== previousSecret) {
        console.log(`Detected new secret key from clipboard: ${secret}`);
        previousSecret = secret;
    }

    try {
        // Generate TOTP code using the current secret
        const currentToken = otplib.authenticator.generate(secret);

        // If the current token is different from the last token, log it
        if (currentToken !== lastToken) {
            console.log(`New 2FA code: ${currentToken}`);
            lastToken = currentToken;
        }
    } catch (error) {
        console.error("Error generating TOTP code:", error.message);
    }
}

// Run the clipboard read and TOTP generation every second, only on Windows
if (process.platform === "win32") {
    setInterval(() => {
        readClipboard((clipboardContent) => {
            if (validSecretLengths.includes(clipboardContent.length)) {
                checkForNewCode(clipboardContent);
            } else {
                checkForNewCode(previousSecret);
            }
        });
    }, 1000);
} else {
    console.log("This script only runs on Windows.");
}
