const fs = require('fs');
const path = require('path');
const { exec } = require('child_process');

// Function to clear Downloads folder
function clearDownloadsFolder() {
    const downloadsPath = path.join(process.env.HOMEPATH, 'Downloads');

    fs.readdir(downloadsPath, (err, files) => {
        if (err) {
            console.error('Error reading Downloads folder:', err);
            return;
        }

        files.forEach((file) => {
            const filePath = path.join(downloadsPath, file);
            fs.unlink(filePath, (err) => {
                if (err) {
                    console.error(`Failed to delete ${file}:`, err);
                } else {
                    console.log(`Deleted: ${file}`);
                }
            });
        });
    });
}

// Function to close incognito Firefox
function closeIncognitoFirefox() {
    exec('tasklist', (err, stdout) => {
        if (err) {
            console.error('Error listing tasks:', err);
            return;
        }

        const firefoxProcesses = stdout
            .split('\n')
            .filter(line => line.includes('firefox.exe'));

        if (firefoxProcesses.length > 0) {
            exec('taskkill /IM firefox.exe /F', (err) => {
                if (err) {
                    console.error('Error closing Firefox:', err);
                } else {
                    console.log('Closed Firefox incognito windows');
                }
            });
        } else {
            console.log('No Firefox processes running');
        }
    });
}

// Function to close all cmd.exe processes
function closeCmdProcesses() {
    exec('tasklist', (err, stdout) => {
        if (err) {
            console.error('Error listing tasks:', err);
            return;
        }

        const cmdProcesses = stdout
            .split('\n')
            .filter(line => line.includes('cmd.exe'));

        if (cmdProcesses.length > 0) {
            exec('taskkill /IM cmd.exe /F', (err) => {
                if (err) {
                    console.error('Error closing CMD processes:', err);
                } else {
                    console.log('Closed all CMD processes');
                }
            });
        } else {
            console.log('No CMD processes running');
        }
    });
}

// Run the functions
clearDownloadsFolder();
closeIncognitoFirefox();
closeCmdProcesses();
