#!/bin/bash

# Update package index
apt update

# Install necessary prerequisites
apt install -y apt-transport-https ca-certificates curl software-properties-common

# Add Docker’s official GPG key
curl -fsSL https://download.docker.com/linux/ubuntu/gpg | apt-key add -

# Add Docker APT repository
add-apt-repository "deb [arch=amd64] https://download.docker.com/linux/ubuntu $(lsb_release -cs) stable"

# Update package index again
apt update

# Install Docker
apt install -y docker-ce

# Start and enable Docker
systemctl start docker
systemctl enable docker

# Verify Docker installation
docker --version

# Create Docker group if it doesn't exist
if ! getent group docker > /dev/null; then
  groupadd docker
fi

# Add the current user to the Docker group
usermod -aG docker $USER

# Install Portainer
docker volume create portainer_data

docker run -d -p 80:9000 --name=portainer --restart=always \
  -v /var/run/docker.sock:/var/run/docker.sock \
  -v portainer_data:/data portainer/portainer-ce

# Verify Portainer installation
docker ps -a

echo "Docker and Portainer have been installed successfully. Portainer is running on port 80."

# End of script
