let fs = require('fs')
let csv = require('./csv')
let _ = require('lodash')
let directory
let csvFile
//const perf = require('execution-time')();
run()

async function run() {
    var args = process.argv.slice(2);
    directory = args[0]
    await makeStatus(directory, '1')
    //  perf.start()
    let configs = await fs.readFileSync('./configs.json', 'utf8')
    configs = JSON.parse(configs)
    let arr = []
    let files = await fs.readdirSync('./' + directory)

    for (let i = 0; i < files.length; i++)
        if (files[i].includes('.csv')) {
            csvFile = files[i]
            arr.push(csv.parse(directory, files[i], configs.data))
        }

    arr = await Promise.all(arr)
    let count = 0
    let arr2 = []
    let arr3 = []
    for (let i = 0; i < arr.length; i++) {
        let inline = arr[i]
        for (let j = 0; j < inline.length; j++) {
            arr2.push(inline[j])


        }
    }
    //   console.log(arr2)

    arr2 = _.orderBy(arr2, [configs.sort], ['desc']);
    let arr20Max = []
    let arr1000Compound = []

    let arrReserv = _.orderBy(arr2, ['percentage'], ['asc']);
    let arrCompound = _.orderBy(arr2, ['compoundPerMonth'], ['desc']);
    let arrResrv200 = []
    let arrReservCompound = []
    for (let i = 0; i < 1000; i++) {
        arr3.push(arr2[i])
        arrResrv200.push(arrReserv[i])
        arr1000Compound.push(arrCompound[i])
    }

    for (let i = 0; i < arr2.length; i++) {

        if (arr2[i].allocatedReserve < 3)
            arr20Max.push(arr2[i])
    }

    for (let i = 0; i < arrCompound.length; i++) {

        if (arrCompound[i].allocatedReserve < 3)
            arrReservCompound.push(arrCompound[i])
    }


    let timestamp = Date.now()
    try {
        await fs.mkdirSync('result/' + csvFile)
    } catch (e) {

    }

    await fs.unlinkSync(directory + '/' + csvFile)
   // createfileADV('allDataSortedByProfit', JSON.stringify(arr2, null, 2))
     createfileADV('profitPerMonth1000', JSON.stringify(arr3, null, 2))
     createfileADV('percentage1000', JSON.stringify(arrResrv200, null, 2))
     createfileADV('compound1000', JSON.stringify(arr1000Compound, null, 2))
     createfileADV('allocatedReservePerMonthUnder3', JSON.stringify(arr20Max, null, 2))
     createfileADV('allocatedReserveCompoundUnder3' , JSON.stringify(arrReservCompound, null, 2))

    arr20Max=[]
    for (let i = 0; i < arr2.length; i++) {

        if (arr2[i].allocatedReserve < 2)
            arr20Max.push(arr2[i])
    }
    arrCompound=[]
    for (let i = 0; i < arrCompound.length; i++) {

        if (arrCompound[i].allocatedReserve < 2)
            arrReservCompound.push(arrCompound[i])
    }

    createfileADV('allocatedReservePerMonthUnder2', JSON.stringify(arr20Max, null, 2))
    createfileADV('allocatedReserveCompoundUnder2' , JSON.stringify(arrReservCompound, null, 2))





    console.log('Done')
    await makeStatus(directory, '0')
    //   process.exit(0)
    // console.log(d)
}

function createfile(data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/result.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}

function createfileADV(filename, data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile('result/' + csvFile + '/' + filename + '.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}


function createfile2(data) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/profitPerMonth1000.json', data, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(data);
        });
    });
}


async function test2() {
    let configs = await fs.readFileSync('./configTemp.json', 'utf8')
    configs = JSON.parse(configs)
    console.log(configs)
}


function makeStatus(directory, status) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/work' + '.txt', status, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}



