let fs = require('fs')
let _ = require('lodash')
var shell = require('shelljs');
let prefix = 'work'
let cores = 15


init()


async function init() {


    for (let i = 0; i < cores; i++) {
        let res = await fs.existsSync(prefix + i)
        if (!res) {
            await fs.mkdirSync(prefix + i)

        }
        await makeStatus(prefix + i)
    }


    check()


}

function makeStatus(directory) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/work' + '.txt', '0', 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function check() {
    let files = await fs.readdirSync('files')
    let size = await fs.read
    for (let i = 0; i < files.length; i++) {

        if (!files[i].includes('csv')) {
            await fs.unlinkSync('files/' + files[i])
            continue
        }

        let stats = await fs.statSync('files/' + files[i])
        if (stats.size < 500) {

            await fs.unlinkSync('files/' + files[i])
            continue
        }
        //  console.log(stats.size)


        let worker = await findOffWorker()
        //  console.log(worker)

        if (worker !== null) {
            await fs.renameSync('files/' + files[i], worker + '/' + files[i])
            await makeStatusNew(worker, '1')
            shell.exec('node run.js ' + worker, {async: true});
        }


    }

    await sleep(250)
    return check()


    //  console.log(files)
}

function sleep(millis) {
    return new Promise(resolve => setTimeout(resolve, millis));
}


function makeStatusNew(directory, status) {
    return new Promise(function (resolve, reject) {
        fs.writeFile(directory + '/work' + '.txt', status, 'utf8', function (err) {
            if (err) reject(err);
            else resolve(true);
        });
    });
}


async function findOffWorker() {
    let arr = []
    for (let i = 0; i < cores; i++) {
        let res = await fs.readFileSync('./' + prefix + i + '/work.txt', 'utf8');
        if (res.includes('0'))
            arr.push(prefix + i)

    }
    arr = _.shuffle(arr)
    if (arr.length !== 0)
        return arr[0]

    else return null

}