const axios = require('axios');
const fs = require('fs').promises;
const cron = require('node-cron');
const { exec } = require('child_process');
const util = require('util');
const execPromise = util.promisify(exec);

const BASE_URL = "http://78.46.244.55:2020";
const CONFIG_PATH = '/etc/haproxy/haproxy.cfg';

async function run() {
    try {
        const data = await getTunnel();
        const config = data.config;
        console.log('data getter',config)
        await processConfig(config);
    } catch (error) {
        console.error(error);
    }
}

async function processConfig(newConfig) {
    try {
        const currentConfig = await fs.readFile(CONFIG_PATH, 'utf8');

        if (currentConfig !== newConfig) {
            console.log('config is not same try change and reload')
            await fs.writeFile(CONFIG_PATH, newConfig);
            await reloadHAProxy();
        }
        else
        {
            console.log('config is same')
        }
    } catch (error) {
        throw error;
    }
}

async function reloadHAProxy() {
    try {
        const { stdout, stderr } = await execPromise('sudo systemctl reload haproxy');
        console.log('HAProxy reloaded successfully:', stdout);
        if (stderr) {
            console.error('Reload error:', stderr);
        }
    } catch (error) {
        throw error;
    }
}

async function getTunnel() {
    try {
        const response = await axios.get(`${BASE_URL}/getTunnel`, { timeout: 3000 });
        return response.data;
    } catch (error) {
        throw 'Error fetching tunnel configuration';
    }
}


run();

cron.schedule('*/5 * * * * *', main);
