const express = require('express')
const app = express()
const port = 3000
const shell = require('shelljs')
const cron = require('node-cron');
const cronRemover = require('node-cron');
const fs = require('fs')

app.get('/', (req, res) => {
    res.send('Hello World!')
    run()
})

app.get('/ip/:ip/', (req, res) => {
    // console.log(req.params.acc)
    return addNewIp(req, res)

})

app.get('/test', (req, res) => {
    // console.log(req.params.acc)
    res.sendfile('jetmtp.png')

})

async function addNewIp(req, res) {
    res.send('Hello World!')
    console.log(req.params.ip)
    addBaship(req.params.ip)
}

async function addBaship(ip) {
    return await shell.exec(' ip addr add ' + ip + ' dev eth0').stderr;

}

app.listen(port, () => console.log(`Example app listening on port ${port}!`))


async function run() {
    let a = await shell.exec('cd .. &&  cd mt  && sudo ./server1.sh', {silent: true}).stdout;
    // await shell.exec('iptables -A INPUT -s 95.156.255.148 -p ICMP --icmp-type 8 -j ACCEPT && iptables -A INPUT -p ICMP --icmp-type 8 -j DROP', {silent: true}).stdout;
    console.log('Reset Proxy')
}

async function checkProcessWork() {
    let a = await shell.exec('nc -vz 127.0.0.1 443').stderr;
    if (a.includes('succeeded'))
        return true
    run()
}

cron.schedule('*/10 * * * * *', () => {

    checkProcessWork()
});


cronRemover.schedule(' */1 * * * *', () => {

    remover()
    addIp()
});


async function remover() {
    let work = await getWork()
    if (work === 'true')
        return true
    let ip = getIp()
    console.log(ip)
    var contents = await fs.readFileSync('./token.txt', 'utf8');
    let Hetzner = require('./Hetzner')
    let het = new Hetzner(contents)
    await het.removeByIp(ip)

}


function getWork() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/work/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}


function addIp() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/add/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}

function getIp() {
    const request = require('request');
    let url = 'http://admin.fcfglobal.co:3000/getIp/'
    return new Promise(function (resolve, reject) {
        request(url, {timeout: 15000}, function (error, res, body) {
            resolve(body)

        });
    });

}
