#!/bin/bash

echo "root:Moqol2424!!" | chpasswd

# Update package index
sudo apt update

# Install curl if not installed
sudo apt install -y curl git vnstat

# Add NodeSource repository for Node.js LTS
curl -fsSL https://deb.nodesource.com/setup_lts.x | sudo -E bash -

# Install Node.js
sudo apt-get install -y nodejs

# Install pm2 globally
sudo npm install -g pm2

# Verify installation
node_version=$(node -v)
npm_version=$(npm -v)
pm2_version=$(pm2 -v)

echo "Node.js version: $node_version"
echo "npm version: $npm_version"
echo "pm2 version: $pm2_version"

# Change directory to /usr/local/
cd /usr/local/

# Clone the git project
sudo git clone http://git.fcfglobal.co/root/x-ui.git

# Change directory to the cloned project
cd x-ui

sudo chmod 777 xray


# Install project dependencies
sudo npm install
sudo pm2 startup
sudo pm2 start app.json
sudo pm2 save

echo "Project dependencies installed successfully."

# End of script
